package com.waytous.anticollision.di

import android.content.Context
import android.view.LayoutInflater
import com.waytous.anticollision.R
import com.waytous.anticollision.databinding.LayoutMapBoxBinding
import com.waytous.anticollision.databinding.RadioTabCollectBinding
import com.waytous.anticollision.databinding.RadioTabSettingsBinding
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.components.ActivityComponent
import dagger.hilt.android.qualifiers.ActivityContext
import dagger.hilt.android.scopes.ActivityScoped

@InstallIn(ActivityComponent::class)
@Module
object FragmentModule {

    @ActivityScoped
    @Provides
    fun provideMapBoxInflater(@ActivityContext context: Context): LayoutMapBoxBinding {
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.layout_map_box,null)
        }
        return LayoutMapBoxBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideRadioTabCollect(@ActivityContext context: Context):RadioTabCollectBinding{
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.radio_tab_collect,null)
        }
        return RadioTabCollectBinding.inflate(layoutInflater,null,false)
    }

    @ActivityScoped
    @Provides
    fun provideRadioTabSettings(@ActivityContext context: Context):RadioTabSettingsBinding{
        val layoutInflater = LayoutInflater.from(context).also {
            it.inflate(R.layout.radio_tab_settings,null)
        }
        return RadioTabSettingsBinding.inflate(layoutInflater,null,false)
    }
}