package com.waytous.anticollision.bean


import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import com.squareup.moshi.Json

/**
 * 地图数据源
 * @author male
 * */
@Entity(tableName = "map_source")
data class MapDataSource(
    /**数据源ID*/
    @PrimaryKey
    @ColumnInfo(name = "sourceId")
    @Json(ignore = true)
    var sourceId:String = "",
    /**地图geojson数据*/
    @ColumnInfo(name = "geojson")
    @Json(name = "geojson")
    val geojson: String = "",
    /**地图geojson数据版本*/
    @ColumnInfo(name = "version")
    @Json(name = "version")
    val version: String = "-1"
)