package com.waytous.anticollision.api

import com.squareup.moshi.Moshi
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory
import com.waytous.anticollision.BuildConfig
import com.waytous.anticollision.bean.MapDataSource
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.moshi.MoshiConverterFactory
import retrofit2.http.GET
import retrofit2.http.Query

interface MapSourceService {

    /**
     * 获取障碍物图层数据
     * @param version
     * */
    @GET("api/map/obstaclesversion")
    suspend fun obstaclesVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取电子围栏图层数据
     * @param version
     * */
    @GET("api/map/electronicFenceversion")
    suspend fun electronicFenceVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取湿滑区域图层数据
     * @param version
     * */
    @GET("api/map/wetAreaversion")
    suspend fun wetAreaVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取车道节点图层数据
     * @param version
     * */
    @GET("api/map/lanenodeversion")
    suspend fun laneNodeVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取车道图层数据
     * @param version
     * */
    @GET("api/map/laneversion")
    suspend fun laneVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取可行使区域图层数据
     * @param version
     * */
    @GET("api/map/runableareaversion")
    suspend fun runnableAreaVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取卸载区图层数据
     * @param version
     * */
    @GET("api/map/dumpareaversion")
    suspend fun dumpAreaVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取装载区图层数据
     * @param version
     * */
    @GET("api/map/diggingworkareaversion")
    suspend fun diggingWorkAreaVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取挡墙图层数据
     * @param version
     * */
    @GET("api/map/barricadeversion")
    suspend fun barricadeVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取静态区域图层数据
     * @param version
     * */
    @GET("api/map/stationareaversion")
    suspend fun stationAreaVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取静态区域图层数据
     * @param version
     * */
    @GET("api/map/staticobjsversion")
    suspend fun staticObjectsVersion(@Query("version") version:String = "-1"): MapDataSource?
    /**
     * 获取停车位图层数据
     * @param version
     * */
    @GET("api/map/parkspotversion")
    suspend fun parkSpotVersion(@Query("version") version:String = "-1"): MapDataSource?

    companion object {
        private val BASE_URL by lazy {
            if (BuildConfig.DEBUG) BuildConfig.TEST_MAP_SOURCE_HOST else BuildConfig.DEV_MAP_SOURCE_HOST
        }

        private val moshi: Moshi = Moshi.Builder()
            .add(KotlinJsonAdapterFactory())
            .build()

        fun create(): MapSourceService {
            val logger = HttpLoggingInterceptor().apply { level = HttpLoggingInterceptor.Level.BASIC }

            val client = OkHttpClient.Builder()
                .addInterceptor(logger)
                .build()

            return Retrofit.Builder()
                .baseUrl(BASE_URL)
                .client(client)
                .addConverterFactory(MoshiConverterFactory.create(moshi))
                .build()
                .create(MapSourceService::class.java)
        }
    }
}