package com.waytous.anticollision

import android.os.Bundle
import android.os.RecoverySystem
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.setupWithNavController
import com.blankj.utilcode.util.Utils
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.gyf.immersionbar.ImmersionBar
import com.waytous.anticollision.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        supportActionBar?.hide()
        ImmersionBar.with(this)
            .statusBarAlpha(0.0f)
            .statusBarDarkFont(true)
            .fitsSystemWindows(true)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)
        initNavView()
    }

    private fun initNavView(){
        val navView: BottomNavigationView = binding.navView
        val fragmentContainerView = supportFragmentManager.findFragmentById(R.id.nav_host_fragment_activity_main) as NavHostFragment
        val navController = fragmentContainerView.navController
        navView.setupWithNavController(navController)
    }
}