// 通过对象属性的唯一值 从树型数组中提取对象 返回他
export function recursion(data, id, current) {
  var result = null;
  if (!data) {
    return;
  }
  for (var i in data) {
    if (result !== null) {
      break;
    }
    var item = data[i];
    if (item[id] == current) {
      result = item;
      break;
    } else if (item.children && item.children.length > 0) {
      result = recursion(item.children, id, current);
    }
  }
  return result;
}

// 通过对象属性的唯一值 从树型数组中提取对象 删除他返回其他的
export function recursionRemove(data, id, current) {
  for (var i = 0; i < data.length; i++) {
    if (data[i][id] == current) {
      data.splice(i, 1);
    }
  }
  return data;
}

// 判断是否是基本数据类型

export function isBasicType(val = '') {
  const t = Object.prototype.toString.call(val);
  if (
    t == '[object String]' ||
    t == '[object Boolean]' ||
    t == '[object Number]' ||
    t == '[object Null]' ||
    t == '[object Undefined]' ||
    t == '[object Symbol]'
  ) {
    return true;
  }
  return false;
}

export function tableReault(promise) {
  var data = {
    data: promise,
    page: 1,
    success: true,
    total: 1,
  };
  console.log(data);
  return data;
}

export function downloadExcel(blob, fileName) {
  const a = document.createElement('a');
  a.download = fileName;
  a.href = URL.createObjectURL(blob);
  a.style.display = 'none';
  document.body.appendChild(a);
  a.click();
  URL.revokeObjectURL(a.href);
  document.body.removeChild(a);
}


export function getAllChildren(arr) {
  let result = [];

  // 遍历传入的数组  
  for (let i = 0; i < arr.length; i++) {
    const item = arr[i];

    if (item.children && item.children[0] && item.children[0].name == "查看") {
      // 将当前项添加到结果数组中  
      result.push(item);
    }

    // 如果当前项有children属性且是一个数组  
    if (item.children && Array.isArray(item.children)) {
      // 递归调用getAllChildren函数，并将返回的数组与当前结果合并  
      result = result.concat(getAllChildren(item.children));
    }
  }

  return result;
}


// 页面权限设置增删改查等
export function curdSet(name) {
  const User = JSON.parse(window.sessionStorage.getItem('User'));
  let obj = []

  if (User.permissions) {
    let PageLimits = User.permissions[0]?.children[0].children

    // 使用函数  返回所有children下的page子页面的对象
    const allChildren = getAllChildren(PageLimits);
    console.log(allChildren);

    // 获取页面路由的查看权限
    for (let index = 0; index < allChildren.length; index++) {
      const element = allChildren[index];
      if (element.name === name) {
        obj = element?.children
      }
    }

  }
  return obj
};

