// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';


const url = '/api/iot/rule';
const urlSearchTable = '/api/iot/_search/rule';



/** 根据 ID 获取 设备信息 */
export async function getRule(
  id: string,
  options?: { [key: string]: any },
) {

  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  }).then((res: any) => {
    for (let index = 0; index < res.length; index++) {
      const element = res[index];
      element.label = element.name
      element.value = element.id
    }
    return res
  });
}



/** 删除 设备信息 */
export async function delRule(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}



/** 新增 设备信息 */
export async function addRule(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'POST',
    data: data,
    ...(options || {}),
  });
}



/** 更新 设备信息 */
export async function updateRule(
  data: API.IOT.Manufacturer,
  id: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}



/** 查询 设备信息 */
export async function findRule(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 获取设备信息管理列表 */
export async function searchTableRule(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(urlSearchTable, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      size: params.pageSize,
      page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    return res
  });

}


