// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';

const url = '/api/iot/transfer';
const urlSearchTable = '/api/iot/_search/transfer';

/** 根据 ID 获取 设备信息 */
export async function getConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}

/** 删除 设备信息 */
export async function delConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(url + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}

/** 新增 设备信息 */
export async function addConnect(data: API.IOT.Device, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(url, {
    method: 'POST',
    data,
    ...(options || {}),
  });
}

/** 更新 设备信息 */
export async function updateConnect(
  data: API.IOT.Device,
  id: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(url + '/' + id, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}

/** 查询 设备信息 */
export async function findConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}

/** 获取设备信息管理列表 */
export async function searchTableConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(urlSearchTable, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      size: params.pageSize,
      page: params.current,
    },
    ...(options || {}),
  }).then((res) => {
    let result = {
      data: res,
      total: 1,
      success: true,
    };
    console.log(result);

    return result;
  });
}
