// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';

const findUrl = "/api/core/org/user/username"   //查询所有  get请求
const findAccountUrl = "/api/account"   //查询所有  get请求

const rolesUrl = "/api/core/org/user/roles"   //查询所有  get请求
const permissionsUrl = "/api/core/org/role/permissions"   //查询所有  get请求
const resourcesUrl = "/api/core/org/permission/resources"   //查询所有  get请求

const updateUrl = "/api/users/update"   //查询所有  get请求
const urlImageUpload = '/polls/user/upload'; /** 图片上传 */



/** 根据 ID 获取用户信息 */
export async function getAccount(options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(findAccountUrl, {
    method: 'GET',
    ...(options || {}),
  });
}

/** 根据 ID 获取用户信息 */
export async function getUser(name: string, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(findUrl + '/' + name, {
    method: 'GET',
    ...(options || {}),
  });
}

/** 根据 ID 获取用户信息 */
export async function getRolesUser(name: string, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(rolesUrl + '/' + name, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 根据 ID 角色许可  */
export async function getPermissionsUser(name?: string, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(permissionsUrl + (name ? '/' + name : ''), {
    method: 'GET',
    ...(options || {}),
  });
}

/** 根据 ID 许可资源 */
export async function getResourcesUser(name: string, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(resourcesUrl + '/' + name, {
    method: 'GET',
    ...(options || {}),
  });
}

/** 登录接口 POST /api/ */
export async function updateUser(body: API.LoginParams, options?: { [key: string]: any }) {
  return request<API.LoginResult>(updateUrl, {
    method: 'PUT',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}


/** 图片上传 */
export async function imgUploadImage(data: any) {

  return request<any>(urlImageUpload, {
    method: 'POST',
    data,
  })
}



