/**
 * 页面组件数据
 */
export interface PageWidgetData {
    page: string;
    action: 'ONE_TOUCH' | 'ONE_SWAP';
    widget: string;
}



/**
 * 用户操作数据
 */
export interface UserActionData {
    page: string;
    action: 'ONE_TOUCH' | 'ONE_SWAP';
    widget: string;
}




/**
 * 页面组件定义数据
 */
export interface PageWidgetDefineData {
  page   : string;
  widget : string;
  name   : string;
  desc   : string;
  inputType: string;
  response: string;
  exception: string;
  note: string;
}



/**
 * 页面错误数据
 */
export interface PageIssueData {
  serial : number;
  page   : string;
  action : 'ONE_TOUCH' | 'ONE_SWAP';
  widget : string;
  issueType : 'NO_RESPONSE' | 'RESPONSE_ERROR' | 'DISPLAY_ERROR' | 'STYLE_ERROR'
}



/**
 * 
 */
export interface BugListProps {
  dataSource: PageIssueData[];
  onRemove: (data: PageIssueData) => void;
}



/**
 * 页面问题提交表单属性
 */
export interface IssueFormProps {
  /* 用户操作 */
  userAction: UserActionData;
  /* 用户提交事件 */
  onBugSubmit: (data: PageIssueData) => void;
}

/**
 * 页面设计说明表单属性
 */
export interface PageDesignDescFormPorp {
    actionRef? : React.Ref<UserActionData>;
    widget?    : PageWidgetData;    //当前操作组件
}


export const contentStyle: React.CSSProperties = {
    color: '#fff',
    backgroundColor: '#ffffff',
};



export const siderStyle: React.CSSProperties = {
    color: '#fff',
    backgroundColor: '#ffffff',
    height: '100h',
    border: '1px',
    borderBlock:'#F0EEEE',
    paddingRight: '12px'
};



export const parseMessageData = (event:MessageEvent, callback:(any)=>void) => {

    if (event.data instanceof ArrayBuffer) {
      // 将 ArrayBuffer 转换为字符串
      const decoder = new TextDecoder();
      const str = decoder.decode(new Uint8Array(event.data));
  
      // 解析 JSON 字符串
      try {
        // eslint-disable-next-line no-eval
        const data = eval("(" + str + ")");
        callback(data);
      } catch (error) {
        console.error('Failed to parse JSON:', error);
      }
    }else if (event.data instanceof Blob) {
      // 将 Blob 数据读取为 ArrayBuffer
      const reader = new FileReader();
      reader.onloadend = () => {
        const arrayBuffer = reader.result as ArrayBuffer;
        
        // 将 ArrayBuffer 转换为字符串
        const decoder = new TextDecoder('utf-8'); 
        const str = decoder.decode(new Uint8Array(arrayBuffer));
  
        // 解析 JSON 字符串
        try {  
          // eslint-disable-next-line no-eval
          const data = eval("(" + str + ")");
          
          callback(data);
        } catch (error) {
          console.error('Failed to parse JSON:', error);
        }
      };
      reader.readAsArrayBuffer(event.data);
    } else {
        console.error('Received non-Blob data');
        
        callback(event.data);
    }
}