import { useRef, useState, useEffect } from 'react';
import { PlusOutlined } from '@ant-design/icons';
import {
  ProTable,
  ProForm,
  ProFormText,
  ModalForm,
  ProFormSelect,
  ProFormTextArea
} from '@ant-design/pro-components';
import { Button, Card, Spin, Popconfirm, message } from 'antd';
import { PageContainer } from '@ant-design/pro-layout';
import { aquestionPageConnect } from '@/services/TestQuestionBank/';



export default () => {
  const actionRef = useRef<any>();
  const [spinning, setSpinning] = useState<any>(false);
  const [pageSize, setPageSize] = useState<any>(10);

  const formRef = useRef<any>();
  const [modalVisit1, setModalVisit1] = useState(false);
  const [addVis, setAddVis] = useState(true);
  const [removeVis, setRemoveVis] = useState(true);
  const [editVis, setEditVis] = useState(true);
  const [searchVis, setSearchVis] = useState(true);
  const [editData, setEditData] = useState({});
  const [roleId, setRoleId] = useState<any>(null);
  const [activeType, setActiveType] = useState<any>('add');
  const [roleData, setRoleData] = useState<any>([]);

  useEffect(() => {
    return () => {
    };
  }, []);


  const columns = [
    { align: 'center', title: "序号", search: false, width: 68, render: (text, record, index) => `${index + 1}`, },
    {
      // search: false,
      title: '标题',
      align: 'center',
      render: (text: any, item: any) => {
        return <div>{item?.title}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '类型',
      render: (item: any) => {
        return <div> {item?.type}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '得分',
      render: (item: any) => {
        return <div>{item?.score}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '模块功能',
      render: (item: any) => {
        return <div>{item?.moduleFunc}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '窗口名称',
      render: (item: any) => {
        return <div>{item?.widgetName}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '备注',
      render: (item: any) => {
        return <div> {item?.note}</div>
      },
    },
    {
      title: '操作',
      dataIndex: 'x',
      align: 'center',
      valueType: 'option',
      key: '5',
      render: (_, record) => {
        return [
          <> <Button
            key="editable"
            type="primary"
            style={!editVis ? {} : { background: '#2db7f5', border: 'none' }}
            disabled={!editVis}
            onClick={async (e) => {
              setModalVisit1(true);
              setActiveType('update')
              await onEdit(record);
            }}
          >
            修改
          </Button> </>,
          <>
            <Popconfirm
              title="确认删除？"
              onConfirm={() => {
                adminUserRemoveConnect(record?.id).then((res: any) => {
                  console.log(res);
                  message.success('删除成功');
                })
              }}
              onCancel={() => { }}
              disabled={!removeVis}
            >
              <Button
                key="remove"
                type="primary"
                danger
                disabled={!removeVis}
              >
                删除
              </Button>
            </Popconfirm>
          </>
        ];
      },
    },
  ];



  // 编辑回显
  const onEdit = (record: any) => {
    setTimeout(() => {
      formRef?.current?.setFieldsValue(record);
      setEditData(record)
      setRoleId(record?.id)
    }, 100)
  };

  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <ProTable
          columns={columns}
          actionRef={actionRef}
          cardBordered
          request={aquestionPageConnect}
          columnsState={{
            persistenceKey: 'pro-table-singe-demos',
            persistenceType: 'sessionStorage',
            onChange(value: any) {
              console.log('value: ', value);
            },
          }}
          scroll={{ y: 480 }}
          rowKey="id"
          // search={false}
          options={{
            setting: {
              listsHeight: 400,
            },
          }}
          pagination={{
            pageSize: pageSize,
            showSizeChanger: true,
            onChange: (page: any, pageSize: any) => setPageSize(pageSize),
          }}
          dateFormatter="string"
          toolBarRender={() => [
            <>
              <Button
                key="button"
                icon={<PlusOutlined />}
                type="primary"
                disabled={!addVis}
                onClick={() => {
                  setModalVisit1(true);
                  setActiveType('add')
                  formRef?.current?.resetFields();
                }}
              >
                新建
              </Button>
            </>
          ]}
        />
      </Spin>

      {/* 角色新建和修改 */}
      <ModalForm
        formRef={formRef}
        title="角色设置"
        visible={modalVisit1}
        onVisibleChange={setModalVisit1}
        onFinish={(e) => {
          if (activeType === 'add') {
            userAdd(e)   // 新增
          } else {
            userUpdate(e)   // 修改
          }
          return true;
        }}
      >
        <Card>
          <ProForm.Group>
            <ProFormText width="md" name="title" label="标题" placeholder="请输入标题" />
            <ProFormText width="md" name="score" label="得分" placeholder="请输入得分" />
          </ProForm.Group>
          <ProForm.Group>
            <ProFormSelect
              name="type"
              label="类型"
              width="md"
              request={async () => roleData}
              placeholder="请选择类型"
              fieldProps={{
                fieldNames: {
                  label: 'label', value: 'value'
                }
              }}
            />
            <ProFormSelect
              name="moduleFunc"
              label="模块功能"
              width="md"
              request={async () => roleData}
              placeholder="请选择模块功能"
              fieldProps={{
                fieldNames: {
                  label: 'label', value: 'value'
                }
              }}
            />
          </ProForm.Group>
          <ProForm.Group>
            <ProFormText width="md" name="widgetName" label="窗口名称" placeholder="请输入窗口名称" />
          </ProForm.Group>
          <ProForm.Group>
            <ProFormTextArea width="md" name="note" label="备注" placeholder="请输入备注" />
          </ProForm.Group>
        </Card>
      </ModalForm>
    </PageContainer>
  );

};