import { PlusOutlined } from '@ant-design/icons';
import {
  ProTable,
  DrawerForm,
  ProForm,
  ProFormSelect,
  ProFormText,
  ProFormTextArea,
  ModalForm,
  ProFormDigit,
  ProFormUploadButton
} from '@ant-design/pro-components';
import { async } from '@antv/x6/lib/registry/marker/async';
import { Button, Tabs, Avatar, Card, Tag, Collapse, Layout, Col, Row, Form, Input, Select } from 'antd';

import { useRef, useState } from 'react';
import { DownOutlined } from '@ant-design/icons';
import { Dropdown, Menu, Popconfirm, Space } from 'antd';
import { PageContainer } from '@ant-design/pro-layout';

import React from 'react';

export type Permission = {
  id: string;
  name: string;
  path: string;
  component: string;
  permissionValue: string;
  type: number;
};

export default () => {
  const actionRef = useRef<any>();
  const formRef = useRef<any>();
  const [modalVisit, setModalVisit] = useState(false);
  const { Header, Footer, Sider, Content } = Layout;
  const { Meta } = Card;
  const DemoBox: React.FC<{ children: React.ReactNode; value: number }> = props => (
    <p className={`height-${props.value}`}>{props.children}</p>
  );

  // 查看详情
  const onView = (record: any) => {
    setTimeout(() => {
      formRef?.current?.setFieldsValue(record);
    }, 100)
  };

  const tableListDataSource: Permission[] = [
    {
      "id": '100001',
      "name": '全部数据',
      "path": '/',
      "component": 'Layout',
      "permissionValue": '0',
      "type": 0,
    },
  ];


  const renderRemoveUser = (text: string) => (
    <Popconfirm key="popconfirm" title={`确认${text}吗?`} okText="是" cancelText="否">
      <a>{text}</a>
    </Popconfirm>
  );

  const columns: ProColumns<Permission>[] = [
    {
      dataIndex: 'index',
      valueType: 'indexBorder',
      width: 48,
    },
    {
      dataIndex: 'name',
      title: '名称',
      search: false,
    },
    {
      dataIndex: 'path',
      title: '访问路径',
      search: false,
    },
    {
      dataIndex: 'component',
      title: '组件路径',
      search: false,
    },
    {
      dataIndex: 'permissionValue',
      title: '权限值',
      search: false,
    },
    {
      dataIndex: 'type',
      title: '类型',
      search: false,
    },
    {
      title: '操作',
      dataIndex: 'x',
      valueType: 'option',
      render: (_, record) => {
        let node = renderRemoveUser('移除');
        return [<a
          key="editable"
          onClick={async (e) => {
            setModalVisit(true);
            await onView(record);
          }}
        >
          添加菜单
        </a>, <a
          key="addtable"
          onClick={async (e) => {
            setModalVisit(true);
            await onView(record);
          }}
        >
          修改
        </a>,node];
      },
    },
  ];
  


  return (
    <PageContainer>
      <ProTable<Permission>
        columns={columns}
        request={(params, sorter, filter) => {
          // 表单搜索项会从 params 传入，传递给后端接口。
          console.log(params, sorter, filter);
          return Promise.resolve({
            data: tableListDataSource,
            success: true,
          });
        }}
        rowKey="id"
        pagination={{
          showQuickJumper: true,
        }}
        toolBarRender={false}
        search={{
          labelWidth: 'auto',
        }}
        //search={false}
        
      />

      {/* 查看详情 */}
      <ModalForm
        formRef={formRef}
        submitter={false}
        width={1500}
        title="权限配置"
        visible={modalVisit}
        onVisibleChange={setModalVisit}
        layout={"horizontal"}
      >
      </ModalForm>
  </PageContainer> 
  );

};