import { Modal, Empty, Spin, Collapse, Popconfirm, Row, Col } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import Line from '@/components/Line';
import { PageContainer } from '@ant-design/pro-layout';
import { functionIndustryRatesConnect } from '@/services/SearchVehicle/searchVehicle';


const data = [] as any;
const config = {
  data,
  xField: 'year',
  yField: 'value',
  meta: {
    value: {
      formatter: (v: any) => `${v}%`
    }
  },
  label: {},
  point: {
    size: 5,
    shape: 'diamond',
    style: {
      fill: 'white',
      stroke: '#5B8FF9',
      lineWidth: 2,
    },
  },
  tooltip: {
    showMarkers: false,
  },
  state: {
    active: {
      style: {
        shadowBlur: 4,
        stroke: '#000',
        fill: 'red',
      },
    },
  },
  interactions: [
    {
      type: 'marker-active',
    },
  ],
};

const data2 = [] as any;
const config2 = {
  data: data2,
  xField: 'category',
  yField: 'value',
  seriesField: 'year',
  xAxis: {
    // type: 'time',
  },
  yAxis: {
    label: {
      // 数值格式化为千分位
      // formatter: (v) => `${v}`.replace(/\d{1,3}(?=(\d{3})+$)/g, (s) => `${s},`),
    },
  },
};
export default () => {

  const [data, setData] = useState<any>(config);
  const [data2, setData2] = useState<any>(config2);
  const [title, setTitle] = useState<any>('');
  const [spinning, setSpinning] = useState<any>(false);

  const submit = (type: string, value: any) => {
    console.log(type, value);

    let fIds = value?.function?.value
    let label = value?.function?.label
    console.log(fIds);

    if (!fIds) {
      Modal.warning({
        content: '请先选择功能',
        centered: true
      });
      return
    }

    setSpinning(true)

    functionIndustryRatesConnect({ id: fIds }).then((res) => {
      console.log(res);
      let obj = data
      let obj2 = data2
      obj.data = res.industryRate
      obj2.data = res.levelRate
      for (let index = 0; index < obj2.data.length; index++) {
        obj2.data[index].year = obj2.data[index].year.toString()
      }
      setData({ ...obj })
      setData2({ ...obj2 })
      setTitle(label)
      setSpinning(false)

    })

  };

  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>

        <SearchVehicle
          config={
            {
              submitter: true,
              vehicle: false,
              function: true,
              condition: false,
              functionmultiple: false,
              vehicleUrl: 'searchVehicleConnect'
            }
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* table主体 */}
        <Row gutter={120}>
          <Col span={12}>
            <h3 style={{ fontWeight: 'bold' }}>{title}行业搭载率</h3>
            <div style={{ display: data?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data}></Line>
            </div>
            <Empty style={{ display: data?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
          <Col span={12}>
            <h3 style={{ fontWeight: 'bold' }}>{title}分级别搭载率</h3>
            <div style={{ display: data2?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data2}></Line>
            </div>
            <Empty style={{ display: data2?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
          <Col span={24}>
            <h3 style={{ fontWeight: 'bold' }}>{title}功能大类-时间分析</h3>
            <div style={{ display: data2?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data2}></Line>
            </div>
            <Empty style={{ display: data2?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
          <Col span={24}>
            <h3 style={{ fontWeight: 'bold' }}>{title}场景大类-时间分析</h3>
            <div style={{ display: data2?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data2}></Line>
            </div>
            <Empty style={{ display: data2?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
          <Col span={24}>
            <h3 style={{ fontWeight: 'bold' }}>{title}人群大类-时间分析</h3>
            <div style={{ display: data2?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data2}></Line>
            </div>
            <Empty style={{ display: data2?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
          <Col span={24}>
            <h3 style={{ fontWeight: 'bold' }}>{title}载体大类-时间分析</h3>
            <div style={{ display: data2?.data?.length > 0 ? 'block' : "none" }} >
              <Line config={data2}></Line>
            </div>
            <Empty style={{ display: data2?.data?.length > 0 ? 'none' : "block" }} />
          </Col>
        </Row>
      </Spin>

    </PageContainer>
  );
};
