import { Spin, Modal } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import LabelContent from '@/components/LabelContent';
import { searchTagConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';

export default () => {

  const [data, setData] = useState<any>([]);
  const [spinning, setSpinning] = useState<any>(false);

  const submit = (type: string, value: any) => {
    console.log(type, value);

    let tag = value?.tag
    let vIds = value?.vehicle?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    })

    let tIds = {} as any
    let newTIds = {} as any

    value['五感标签'] ? tIds['五感标签'] = value['五感标签'].map((item: any) => { return item.value }) : ''
    value['人群标签'] ? tIds['人群标签'] = value['人群标签'].map((item: any) => { return item.value }) : ''
    value['功能标签'] ? tIds['功能标签'] = value['功能标签'].map((item: any) => { return item.value }) : ''
    value['场景标签'] ? tIds['场景标签'] = value['场景标签'].map((item: any) => { return item.value }) : ''
    value['高感知载体标签'] ? tIds['高感知载体标签'] = value['高感知载体标签'].map((item: any) => { return item.value }) : ''


    for (let key in tIds) {
      if (Object.prototype.hasOwnProperty.call(tIds, key)) {
        const element = tIds[key];
        if (element.length !== 0) {
          newTIds[key] = tIds[key];
        }
      }
    }

    if (!vIds) {
      Modal.warning({
        content: '请先选择车型',
        centered: true
      });
      return
    }

    setSpinning(true)
    searchTagConnect({ vIds: vIds, tIds: newTIds, tag: tag || 'and' }).then((res) => {
      setSpinning(false)
      if (res && res.code !== "ERR_BAD_RESPONSE") {
        console.log(res);
        setData(res)
      }
    })

  };


  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <SearchVehicle
          config={
            {
              submitter: true,
              vehicle: true,
              condition: true,
              functionmultiple: true,
              vehicleUrl: 'searchVehicleConnect'
            }
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* table主体 */}
        <LabelContent data={data}></LabelContent>
      </Spin>
    </PageContainer>
  );
};
