import { Avatar, Empty, Spin, List, Tabs, Row, Col, Modal } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import { searchTypeConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';
import Pie from '@/components/Pie';
import CountContext from '@/components/Common/CreateContext'
export default () => {

  const [data, setData] = useState<any>([]);
  const [data2, setData2] = useState<any>(null);
  const [imageUrl, setImageUrl] = useState("");
  const [spinning, setSpinning] = useState<any>(false);


  const submit = (type: string, value: any) => {
    console.log(type, value);
    setData2([])

    let fIds = value?.function?.map((item: any, i: any) => {
      return item.value
    })
    console.log(fIds);

    if (!fIds) {
      Modal.warning({
        content: '请先选择功能',
        centered: true
      });
      return
    }
    setSpinning(true)
    searchTypeConnect({ arr: fIds }).then((res) => {
      console.log(res);
      setSpinning(false)
      setData(res)
      setData2(res[0]?.vehicleType)
    })

  };
  const onChange = (e) => {
    setData2(data[e]?.vehicleType)
  }


  const htmlImage = (image: any) => {
    image.then((res: any) => {
      setImageUrl(res)
      console.log(res);
    })
  }

  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>

        <SearchVehicle
          config={
            {
              submitter: true,
              function: true,
              functionmultiple: true,
              vehicleUrl: 'searchVehicleConnect'
            }
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* <img src={imageUrl} alt="Generated" /> */}
        {/* table主体 */}
        <Row>
          <Col span={12}>
            <CountContext.Provider value={htmlImage}>
              <Pie data={data2}></Pie>
            </CountContext.Provider>

          </Col>
          <Col span={12}>
            <div style={{
              display: 'flex',
              justifyContent: 'space-around',
              fontWeight: 'bold'
            }}>
              <h3>功能项</h3>
              <h3>搭载车型</h3>
            </div>
            <Empty style={{ display: data.length > 0 ? 'none' : "block" }} />
            <Tabs
              tabPosition={'left'}
              type="card"
              style={{ height: 400 }}
              onChange={onChange}
              items={data.map((item: any, i: any) => {
                return {
                  label: `${item.title}`,
                  key: i,
                  children: <>
                    <List
                      itemLayout="horizontal"
                      dataSource={item.children}
                      renderItem={(item2: any) => (
                        <List.Item>
                          <List.Item.Meta
                            title={item2.name}
                          />
                        </List.Item>
                      )}
                    />
                  </>,
                }
              })}
            />

          </Col>
        </Row>
      </Spin>
    </PageContainer>
  );
};
