import { Modal, Empty, message, Tooltip, Popconfirm, Tabs, Spin } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import { searchTagRateConnect, clickTagRateConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';
import Column from '@/components/Column';
import AnalysisList from '@/components/AnalysisList';
import CountContext from '@/components/Common/CreateContext'

let tag = '' as String; // 标签选择 

const configConst = {
  data: [],
  xField: 'product_type',
  yField: 'order_amt',
  isGroup: true,
  isStack: true,
  seriesField: 'product_sub_type',
  groupField: 'sex',
  maxColumnWidth: 120,
};
export default () => {
  const [data, setData] = useState<any>([]);
  const [clickData, setClickData] = useState<any>([]);
  const [config, setConfig] = useState<any>(configConst);
  const [spinning, setSpinning] = useState<any>(false);
  const [imageUrl, setImageUrl] = useState("");
  const [screenshot, setScreenshot] = useState(false); // 截图开关 

  const submit = (type: string, value: any) => {
    console.log(type, value);
    let vIds = value.vehicle ? value.vehicle?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    }) : null

    let tagName = value.label ? value.label[0] : null
    tag = tagName // 标签选择
    if (!vIds || !tagName) {
      Modal.warning({
        content: '请先选择车型和标签',
        centered: true
      });
      return
    }

    setSpinning(true)
    searchTagRateConnect({ vIds: vIds, tagName: tagName }).then((res) => {
      console.log(res);
      setSpinning(false)
      message.success('查询完成');
      setData(res)

      let configData = config
      configData.data = res
      setConfig({ ...configData })
      setTimeout(() => {
        setScreenshot(true)
      }, 1000);
    }).catch((error) => {
      console.log(error);
      message.error('请求出错，请重新查询');
      setSpinning(false)
    })

  };

  const htmlImage = (image: any) => {
    image.then((res: any) => {
      setImageUrl(res)
    })
  }


  const dbclick = (data: any) => {
    if (!data) {
      return false
    }
    setSpinning(true)
    data.tag = tag
    clickTagRateConnect({ data }).then((res) => {
      console.log(res);
      setSpinning(false)
      message.success('查询完成');
      setClickData(res)
    }).catch((error) => {
      console.log(error);
      message.error('请求出错，请重新查询');
      setSpinning(false)
    })

  }

  return (
    <PageContainer
      header={{
        breadcrumb: {},
      }}
    >
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <SearchVehicle
          config={
            {
              importEchar: 'label',
              imageUrl: imageUrl,
              submitter: true,
              vehicle: true,
              label: true,
              vehicleUrl: 'searchVehicleConnect',
              labelUrl: 'searchVehiclelabel',
              multiple: true,
            } as any
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        <div style={{ marginBottom: 20, background: '#fff', padding: 20 }}>
          <div style={{ display: data.length > 0 ? 'block' : 'none' }}>
            <h4>子功能数量</h4>
            <Tooltip title={'双击展开'}>
              <div >
                <CountContext.Provider value={htmlImage}>
                  <Column config={config} screenshot={screenshot} dbclick={(e: any) => { dbclick(e) }}></Column>
                </CountContext.Provider>
              </div>
            </Tooltip>
            {/* table主体 */}
            <AnalysisList data={clickData} type="FunctionalLabelAnalysis"></AnalysisList>
          </div>
          <Empty style={{ display: data.length > 0 ? 'none' : "block" }} />
        </div>
      </Spin>
    </PageContainer>
  );
};
