import BoxContent from '@/components/Common/BoxContent'
import React, { useEffect, useState } from 'react'
import './index.less'

// 时间定时器
let currentTimeChange = null as any

const StatisticDemo = (props: any) => {
  const [value1, setsValue1] = useState(46) as any
  const [value2, setsValue2] = useState(54) as any

  useEffect(() => {
    // 更新时间
    currentTimeChange = setInterval(() => {
      setsValue1((prev: any) => {
        if (prev < 100) {
          return prev + 1
        } else {
          return 0 + 1
        }
      })
      setsValue2((prev: any) => {
        if (prev > 1) {
          return prev - 1
        } else {
          return 100
        }
      })
    }, 3000)
    return () => {
      // disconnect()  // 断开连接
    }
  }, [])

  return (
    <>
      <BoxContent {...props}>
        <div id="Statistic">
          <div>
            <div className="echartsImg statistic1_icon">
              <div className="rotate">{value1}</div>
            </div>
            <p>在线设备</p>
          </div>
          <div>
            <div className="echartsImg statistic2_icon">
              <div className="rotate">{value2}</div>
            </div>
            <p>离线设备</p>
          </div>
        </div>
      </BoxContent>
    </>
  )
}

export default React.memo(StatisticDemo)
