
import { ProFormSelect, ProForm, ProFormRadio } from '@ant-design/pro-components';
import { Spin, Space, Row, Col } from 'antd';
import React, { useState, useRef, useEffect } from 'react';

const App: React.FC = (props: any) => {


  const options = [
    {
      label: '轿车', option: [
        {
          label: 'A0级',
          value: 'A0_1',
        },
        {
          label: 'A级',
          value: 'A_1',
        },
        {
          label: 'B级',
          value: 'B_1',
        },
        {
          label: 'C级',
          value: 'C_1',
        },
        {
          label: 'D级',
          value: 'D_1',
        },
      ]
    }, {
      label: 'SUV', option: [
        {
          label: 'A0级',
          value: 'A0_2',
        },
        {
          label: 'A级',
          value: 'A_2',
        },
        {
          label: 'B级',
          value: 'B_2',
        },
        {
          label: 'C级',
          value: 'C_2',
        },
        {
          label: 'D级',
          value: 'D_2',
        },
      ]
    }, {
      label: 'MPV', option: [
        {
          label: 'A0级',
          value: 'A0_3',
        },
        {
          label: 'A级',
          value: 'A_3',
        },
        {
          label: 'B级',
          value: 'B_3',
        },
        {
          label: 'C级',
          value: 'C_3',
        },
        {
          label: 'D级',
          value: 'D_3',
        },
      ]
    }
  ]





  useEffect(() => {


  }, [props.vehicleUrl]);



  const radioChange = (label: any, val: any) => {
    console.log(val);
    props.change(val.target.value, label + ':' + val.target.label)
  }

  const onClear = () => {
    props.onClear()
  }
  

  return (
    <ProForm.Group >
      <Spin spinning={false}>
        <ProFormSelect
          {...props}
          placeholder="请选择级别"
          allowClear
          secondary
          // tree-select args
          fieldProps={{
            options: [],
            onClear:onClear,
            dropdownRender: () => (
              <div style={{ padding: '0 12px' }}>
                {
                  options.map((item: any) => {
                    return <Space style={{ height: 20 }}>
                      <ProFormRadio.Group
                        name="vehicleGroup"
                        label={<span  style={{ width: 30 }}>{item.label}</span>}
                        fieldProps={{
                          onChange: (e: any) => radioChange(item.label, e)
                        }}
                        options={item.option}
                      />
                    </Space>
                  })
                }


              </div>
            ),
          }}
        />
      </Spin>
    </ProForm.Group>
  );
};

export default App;