
import { ProFormTreeSelect } from '@ant-design/pro-components';
import { configurationConnect } from '@/services/SearchVehicle/searchVehicle';
import { Spin } from 'antd';
import React, { useState, useRef, useEffect } from 'react';





const App: React.FC = (props: any) => {


  const [options, setOptions] = useState<any>([])
  const [spinning, setSpinning] = useState<any>(true)


  const onChange = (value: string[]) => {
    console.log(value);
  };

  // 除非子节点 父节点不可点击 
  const recursiveTree = (arr: any) => {
    arr.forEach((item: any) => {
      if (item.children.length > 0) {
        item.selectable = false//父节点不能选中
      }

      if (item.children && item.children.length > 0) {
        recursiveTree(item.children);
      }
    });
    return arr
  }

  useEffect(() => {
    let searchObj = props.searchObj ? props.searchObj : {}
    configurationConnect(searchObj).then((res) => {
      res = recursiveTree(res)   // 除非子节点 父节点不可点击 
      console.log(res);

      setOptions(res)
      setSpinning(false)

    })
  }, [props.searchObj]);
  return (
    <>
      <Spin spinning={spinning}>
        <ProFormTreeSelect
          {...props}
          placeholder="请选择功能"
          allowClear
          secondary
          style={{ height: 100 }}
          // tree-select args
          fieldProps={{
            options: options,
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: props.multiple,
            treeLine: true,
            treeCheckable: props.multiple,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            suffixIcon: false,
            // maxTagCount:5
            // fieldNames: {
            //   value:'label' 
            // },
          }}
        />
      </Spin>
    </>
  );
};

export default App;