
import { Col, message, Row, Space } from 'antd';
import { ProFormSelect, ProForm, ProFormRadio, ProFormTreeSelect } from '@ant-design/pro-components';
import { categoriesConnect } from '@/services/SearchVehicle/searchVehicle';
import React, { useState, useRef, useEffect } from 'react';


interface Option {
  value: string | number;
  label: string;
  children?: Option[];
}




const App: React.FC = (props) => {


  const [options, setOptions] = useState<any>([])


  const onChange = (value: string[]) => {
    console.log(value);
  };

  useEffect(() => {
    categoriesConnect({ arr: ['功能标签', '人群标签', '场景标签', '五感标签', '高感知载体标签'] }).then((res) => {
      console.log(res);
      setOptions(res)
    })

  }, []);

  return (
    <>
      <ProForm.Group title="条件筛查"  {...props}>
        <ProFormTreeSelect
          allowClear
          secondary
          name="功能标签"
          width="xs"
          label="功能标签"
          options={options['功能标签']}
          placeholder="功能标签"
          fieldProps={{
            options: options['功能标签'],
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: true,
            treeLine: false,
            treeCheckable: true,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            fieldNames: {
              label: 'name',
              value: 'id'
            },

          }}
          onChange={onChange}
        />
        <ProFormTreeSelect
          allowClear
          secondary
          name="人群标签"
          width="xs"
          label="人群标签"
          options={options['人群标签']}
          placeholder="人群标签"
          fieldProps={{
            options: options['人群标签'],
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: true,
            treeLine: false,
            treeCheckable: true,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            fieldNames: {
              label: 'name',
              value: 'id'
            },
          }}
          onChange={onChange}
        />
        <ProFormTreeSelect
          allowClear
          secondary
          name="场景标签"
          width="xs"
          label="场景标签"
          options={options['场景标签']}
          placeholder="场景标签"
          fieldProps={{
            options: options['场景标签'],
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: true,
            treeLine: false,
            treeCheckable: true,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            fieldNames: {
              label: 'name',
              value: 'id'
            },
          }}
          onChange={onChange}
        />
        <ProFormTreeSelect
          allowClear
          secondary
          name="五感标签"
          width="xs"
          label="五感标签"
          options={options['五感标签']}
          placeholder="五感标签"
          fieldProps={{
            options: options['五感标签'],
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: true,
            treeLine: false,
            treeCheckable: true,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            fieldNames: {
              label: 'name',
              value: 'id'
            },
          }}
          onChange={onChange}
        />
        <ProFormTreeSelect
          allowClear
          secondary
          name="高感知载体标签"
          width="xs"
          label="高感知载体标签"
          options={options['高感知载体标签']}
          placeholder="高感知载体标签"
          fieldProps={{
            options: options['高感知载体标签'],
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: true,
            treeLine: false,
            treeCheckable: true,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
            treeNodeFilterProp: "label",
            fieldNames: {
              label: 'name',
              value: 'id'
            },
          }}
          onChange={onChange}
        />
      </ProForm.Group>
      <ProFormRadio.Group
        name="tag"
        label="标签筛选"
        fieldProps={{
          defaultValue: 'and',
        }}
        options={[
          {
            label: '满足所有条件',
            value: 'and',
          },
          {
            label: '满足任一条件',
            value: 'or',
          },
        ]}
        onChange={onChange}
      />

    </>


  );
};

export default App;