import React from 'react';
import { PageContainer } from '@ant-design/pro-components';
import './index.less'
export type TabProps = {
    title: string | React.ReactNode;    // 标题
    key: string;
    onFocus?: ((key: string) => void);
}


export type PageComponentProps = {
    title: string | React.ReactNode;    // 标题
    content: React.ReactNode | (() => React.ReactNode);
}

const PageComponent: React.FC<PageComponentProps> = (props) => (
    <PageContainer
        {...props}
    >
        {props.children}
    </PageContainer>
);

export default PageComponent;