import BoxContent from '@/components/Common/BoxContent'
import { PlayCircleOutlined } from '@ant-design/icons'
import { Button } from 'antd'
import React, { useEffect, useState } from 'react'

// 引入 wensocket 模块 监听数据变化
import SockJS from 'sockjs-client'
import Stomp from 'stompjs'

import './index.less'

let stompClient: any = null
let timer: any = null
const ListDemo = (props: any) => {
  const [scorllData, setsScorllData] = useState([
    { time: new Date().toLocaleString(), content: '多车辆行驶交汇', number: 1, id: 'car1' },
    { time: new Date().toLocaleString(), content: '无人机巡航起飞', number: 2, id: 'wrj1' },
    { time: new Date().toLocaleString(), content: '无人船航行', number: 3, id: 'wrc1' },
    { time: new Date().toLocaleString(), content: '多车辆行驶交汇', number: 4, id: 'car1' },
    { time: new Date().toLocaleString(), content: '无人机巡航起飞', number: 5, id: 'wrj1' },
    { time: new Date().toLocaleString(), content: '无人船航行', number: 6, id: 'wrc1' }
  ]) as any

  useEffect(() => {
    initWebSocket() // 初始化WS链接
    return () => {
      // disconnect()  // 断开连接
    }
  }, [])

  useEffect(() => {
    // 在这里执行您想要执行的操作
    // console.log("props 发生变化了", props);
    // let scorllDataNew = scorllData
    // if (scorllDataNew.length > 5) {
    //   scorllDataNew = scorllDataNew.slice(-5)
    //   scorllDataNew.push(props.data)
    // } else {
    //   scorllDataNew.push(props.data)
    // }
    // setsScorllData(scorllDataNew)
  }, [props])

  // 初始化WS链接
  const initWebSocket = () => {
    connection()
    // 断开重连机制,尝试发送消息,捕获异常发生时重连
    timer = setInterval(() => {
      try {
        // that.stompClient.send("test");
      } catch (err) {
        console.log('断线了: ' + err)
        connection()
      }
    }, 5000)
  }
  //连接 后台
  const connection = () => {
    // 建立连接对象
    let socket = new SockJS('/webSocketServer')
    // 获取STOMP子协议的客户端对象
    stompClient = Stomp.over(socket)
    // 定义客户端的认证信息,按需求配置
    let headers = {
      // Authorization: "",
    }
    // 向服务器发起websocket连接
    stompClient.connect(
      headers,
      () => {
        // 获图标数据 变化触发的订阅
        stompClient.subscribe('/topic/warning', (msg: any) => {
          // 订阅服务端提供的某个topic
          console.log('广播成功')
          console.log(msg) // msg.body存放的是服务端发送给我们的信息
          let body = JSON.parse(msg.body) as any
          // alert(body.data.message)
          let data = body.data as any
          let scorllDataNew = scorllData
          if (scorllDataNew.length > 5) {
            scorllDataNew.shift()
            scorllDataNew.push([new Date().toLocaleString(), JSON.parse(data).sceneName])
          } else {
            scorllDataNew.push([new Date().toLocaleString(), JSON.parse(data).sceneName])
          }
          setsScorllData([...scorllDataNew])
        })

        // 获图标数据 变化触发的订阅
        stompClient.subscribe('/iot/scene/v2x', (msg: any) => {
          // 订阅服务端提供的某个topic
          console.log('广播成功')
          console.log(msg) // msg.body存放的是服务端发送给我们的信息
          let body = JSON.parse(msg.body) as any
          // alert(body.data.message)
          let data = body.data as any
          let scorllDataNew = scorllData
          if (scorllDataNew.length > 5) {
            scorllDataNew.shift()
            scorllDataNew.push([new Date().toLocaleString(), JSON.parse(data).sceneName])
          } else {
            scorllDataNew.push([new Date().toLocaleString(), JSON.parse(data).sceneName])
          }
          setsScorllData([...scorllDataNew])
        })
      },
      (err: any) => {
        // 连接发生错误时的处理函数
        console.log('失败')
        console.log(err)
      }
    )
  }
  // 断开连接
  const disconnect = () => {
    if (stompClient) {
      stompClient.disconnect()
    }
  }

  return (
    <>
      <BoxContent {...props}>
        <div id="List">
          <div className="list-title">
            <span>任务编号</span>
            <span>时间</span>
            <span>任务内容</span>
            <span>监控</span>
          </div>
          <div className="list-content">
            {scorllData.map((item: any, i: any) => {
              return (
                <div className={`list-airport`} key={item} style={{ width: `${50 + parseInt(i) * 2}vw` }}>
                  <span>{item.number}</span>
                  <span>{item.time}</span>
                  <span>{item.content}</span>
                  <span>
                    <Button>
                      <PlayCircleOutlined
                        onClick={() => {
                          props?.callFun('ListCall', item.id)
                        }}
                      />
                    </Button>
                  </span>
                </div>
              )
            })}
          </div>
        </div>
      </BoxContent>
    </>
  )
}
export default React.memo(ListDemo)
