import BoxContent from '@/components/Common/BoxContent'
import { Column } from '@ant-design/plots';
import React, { useEffect, useRef } from 'react'

import './index.less'

const DemoLine = (props: any) => {
  const plotRef = useRef(null) as any;

  useEffect(() => {
    const plot = plotRef.current.getChart();
    // element 添加点击事件， element 代表图形元素，关于图形元素，请查看：https://g2.antv.vision/zh/docs/manual/concepts/element
    plot.on('element:dblclick', (...args) => {
      let data = args[0]?.data?.data
      props.dbclick(data)
    });


  }, []);

  return (
    <>
      <BoxContent {...props}>
        <div id="Column">
          <Column ref={plotRef} className="Column" {...props?.config} />
        </div>
      </BoxContent>
    </>
  )
}
export default React.memo(DemoLine)
