﻿/**
 * @name umi 的路由配置
 * @description 只支持 path,component,routes,redirect,wrappers,title 的配置
 * @param path  path 只支持两种占位符配置，第一种是动态参数 :id 的形式，第二种是 * 通配符，通配符只能出现路由字符串的最后。
 * @param component 配置 location 和 path 匹配后用于渲染的 React 组件路径。可以是绝对路径，也可以是相对路径，如果是相对路径，会从 src/pages 开始找起。
 * @param routes 配置子路由，通常在需要为多个路径增加 layout 组件时使用。
 * @param redirect 配置路由跳转
 * @param wrappers 配置路由组件的包装组件，通过包装组件可以为当前的路由组件组合进更多的功能。 比如，可以用于路由级别的权限校验
 * @doc https://umijs.org/docs/guides/routes
 */
export default [
  {
    path: '/user',
    layout: false,
    hideInMenu: true,
    routes: [
      {
        name: 'login',
        path: '/user/login',
        component: './User/Login',
      },
      {
        name: 'register',
        path: '/user/register',
        component: './User/register',
      },
      {
        name: 'welcome',
        path: '/user/welcome',
        component: './User/welcome',
      },
    ],
  },
  {
    path: '/user',
    routes: [
      {
        name: 'center',
        path: '/user/center',
        component: './User/Center',
      },
    ],
  },
  {
    path: '/UIUE',
    name: 'module.UIUE',
    icon: 'database',
    routes: [
      {
        name: 'Console',
        path: '/UIUE/Console',
        component: './UIUE/Console',
        access: 'teacher',
      },
      {
        name: 'UserControl',
        path: '/UIUE/UserControl',
        component: './UIUE/UserControl',
        access: 'teacher',
      },
      {
        name: 'TestQuestionBank',
        path: '/UIUE/TestQuestionBank',
        component: './UIUE/TestQuestionBank',
        access: 'teacher',
      },
    ],
  },
  {
    path: '/Management',
    name: 'module.Management',
    icon: 'database',
    routes: [
      {
        name: 'ClassManagement',
        path: '/Management/ClassManagement',
        component: './ClassManagement',
        access: 'teacher',
      },
      {
        name: 'StudentManagement',
        path: '/Management/StudentManagement',
        component: './StudentManagement',
        access: 'teacher',
      },
    ],
  },
  {
    path: '/TrainingManagement',
    name: 'module.TrainingManagement',
    icon: 'database',
    component: './TrainingManagement',
    access: 'teacher',
  },
  {
    path: '/PerformanceManagement',
    name: 'module.PerformanceManagement',
    icon: 'database',
    component: './PerformanceManagement',
    access: 'teacher',
  },
  {
    path: '/MarkingExams',
    name: 'module.MarkingExams',
    icon: 'database',
    component: './MarkingExams',
    access: 'teacher',
  },
  {
    path: '/Console',
    name: 'module.Console',
    icon: 'save',
    component: './Security/Console',
    access: 'teacher',
  },
  {
    path: '/Limits',
    name: 'module.Limits',
    icon: 'save',
    routes: [
      {
        name: 'User',
        path: '/Limits/User',
        component: './Limits/User',
        access: 'teacher',
      },
      {
        name: 'Role',
        path: '/Limits/Role',
        component: './Limits/Role',
        access: 'teacher',
      },
      // {
      //   name: 'Permissions',
      //   path: '/Limits/Permissions',
      //   component: './Limits/Permissions',
      //   access: 'teacher',
      // },
      // {
      //   name: 'Resources',
      //   path: '/Limits/Resources',
      //   component: './Limits/Resources',
      //   access: 'teacher',
      // },
    ],
  },
  {
    path: '/',
    redirect: '/user/welcome',
  },
  {
    path: '*',
    component: './404',
  },
];
