// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';


const url = '/api/iot/property';
const urlSearchTable = '/api/iot/_search/property';



/** 根据 ID 获取 设备信息 */
export async function getProperty(
  id: string,
  options?: { [key: string]: any },
) {

  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  }).then((res: any) => {
    for (let index = 0; index < res.length; index++) {
      const element = res[index];
      element.label = element.type
      element.value = element.id
    }
    return res
  });
}



/** 删除 设备信息 */
export async function delProperty(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}



/** 新增 设备信息 */
export async function addProperty(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'POST',
    data: data,
    ...(options || {}),
  });
}



/** 更新 设备信息 */
export async function updateProperty(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}



/** 查询 设备信息 */
export async function findProperty(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 获取设备信息管理列表 */
export async function searchTableProperty(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(urlSearchTable, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      size: params.pageSize,
      page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    return res
  });

}


