// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';


const url = '/api/iot/formulas';
const urlSearchTable = '/api/iot/_search/formulas';



/** 根据 ID 获取 设备信息 */
export async function getFormulas(
  id: string,
  options?: { [key: string]: any },
) {

  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  }).then((res: any) => {
    for (let index = 0; index < res.length; index++) {
      const element = res[index];
      element.label = element.formula
      element.value = element.id
    }
    return res
  });
}



/** 删除 设备信息 */
export async function delFormulas(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}



/** 新增 设备信息 */
export async function addFormulas(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'POST',
    data: data,
    ...(options || {}),
  });
}



/** 更新 设备信息 */
export async function updateFormulas(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}



/** 查询 设备信息 */
export async function findFormulas(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 获取设备信息管理列表 */
export async function searchTableFormulas(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(urlSearchTable, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      size: params.pageSize,
      page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    return res
  });

}


