// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';


const url = '/api/iot/eventTrigger';
const urlSearchTable = '/api/iot/_search/eventTrigger';



/** 根据 ID 获取 设备信息 */
export async function getEventTrigger(
  id: string,
  options?: { [key: string]: any },
) {

  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  }).then((res: any) => {
    for (let index = 0; index < res.length; index++) {
      const element = res[index];
      element.label = element.type
      element.value = element.id
    }
    return res
  });
}



/** 删除 设备信息 */
export async function delEventTrigger(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}



/** 新增 设备信息 */
export async function addEventTrigger(
  data: API.IOT.Manufacturer,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url, {
    method: 'POST',
    data: data,
    ...(options || {}),
  });
}



/** 更新 设备信息 */
export async function updateEventTrigger(
  data: API.IOT.Manufacturer,
  id: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}



/** 查询 设备信息 */
export async function findEventTrigger(
  id: string,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(url + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 获取设备信息管理列表 */
export async function searchTableEventTrigger(
  params: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Manufacturer>(urlSearchTable, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params,
    ...(options || {}),
  }).then((res) => {
    let result = {
      "data": res,
      "total": 1,
      "success": true,
    }
    console.log(result);

    return result
  });

}


