// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';
import { message } from 'antd';

const searchVehicle = '/api/vehiclelibraries/vehicle-series/search';
const partial_search = '/api/vehiclelibraries/vehicle-series/partial_search';
const configuration = '/api/vehiclelibraries/vehicle-configuration-categories/tree';
const models = '/api/vehiclelibraries/vehicle-models/searchVehicle';
const categories = '/api/vehiclelibraries/vehicle-function-categories/search';
const searchTag = '/api/vehiclelibraries/vehicle-models/searchTag';
const searchType = '/api/vehiclelibraries/vehicle-models/searchType';
const searchSingleFunction = '/api/vehiclelibraries/vehicle-models/searchSingleFunction';
const functionIndustryRates = '/api/vehiclelibraries/function-industry-rates/search';
const exportUrl = '/api/vehiclelibraries/function/export'; // 车型功能查询下载
const exportUrl2 = '/api/vehiclelibraries/function-find-Vehicle/export'; //功能反向查询下载
const dataxlsxUrl = '/api/vehiclelibraries/function/import'; //功能导入
const userxlsxUrl = '/api/admin/user/import'; //用户导入
const vehicleModelsUrl = '/api/vehiclelibraries/vehicle-models'; //车型增删改查
const vehicleCategoriesUrl = '/api/vehiclelibraries/vehicle-series/searchLevel'; //获取设车型分类列表
const vehiclebrandUrl = '/api/vehiclelibraries/vehicle-brands/all'; //获取设车型分类列表
const vehicletimeUrl = '/api/vehiclelibraries/vehicle-models/searchYear'; //获取分析期间
const searchVehicleFunctionUrl = '/api/vehiclelibraries/vehicle-models/searchVehicleFunction'; //  车型功能迭代（三个都要选，都是单选）
const searchBrandFunctionUrl = '/api/vehiclelibraries/vehicle-models/searchBrandFunction'; //  品牌功能迭代（三个都要选，都是单选
const searchRateUrl = '/api/vehiclelibraries/vehicle-models/searchRate'; // 搭载率
const searchTagRateUrl = '/api/vehiclelibraries/vehicle-models/searchTagRate'; // 功能标签
const clickTagRateUrl = '/api/vehiclelibraries//vehicle-models/clickTagRate'; // 功能标签子表格查询

const adminRolesUrl = '/api/admin/roles'; // 角色管理
const adminUserRoleId = '/api/admin/user/'; // 角色权限查询
const adminRolassignPermission = '/api/admin/user/assignPermission'; // 角色分配权限


const adminUserUrl = '/api/admin/users'; // 用户管理
const adminUserSearchUrl = '/api/admin/user/search'; // 用户管理POST
const modelsUrlSearch = '/api/vehiclelibraries/vehicle-models/search'; // 数据管理
const modelsUrl = '/api/vehiclelibraries/vehicle-models'; // 数据管理

const ImageUploadUrl = '/api/vehiclelibraries/image/import'; /** 图片上传 */
const RateExportUrl = '/api/vehiclelibraries/rate/export'; /** 搭载率导出 */
const tagRateExportUrl = '/api/vehiclelibraries/tagRate/export'; /** 标签分析导出 */
const OperationLogtUrl = '/api/vehiclelibraries/OperationLog'; /** 用户日志 */
const vehicleModelExportUrl = '/api/vehiclelibraries/vehicleModel/export'; /** 数据维护导出 */
const limitsChangeUrl = '/api/admin/users/role'; /** 用户管理变更 */



/** 获取设车型分类列表 */
export async function vehicleCategoriesConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(vehicleCategoriesUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {

    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);

    return res;
  });
}

/** 获取设车型品牌列表 */
export async function vehiclebrandConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(vehiclebrandUrl, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    params: {
      // size: params.pageSize,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);

    return res;
  });
}

/** 获取分析期间 */
export async function vehicletimeConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(vehicletimeUrl, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    params: {
      // size: params.pageSize,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);

    return res;
  });
}

/** 角色查询 */
export async function adminRolesConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
    // login?: String;
  },

  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminRolesUrl, {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      // size: params.pageSize,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}


/** 角色权限查询 */
export async function adminUserRoleIdConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(adminUserRoleId + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 角色权限修改分配权限        */
export async function adminRolassignPermissionConnect(
  params: {
    roleId?: String;
    permissionId?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(adminRolassignPermission, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      roleId: params.roleId,
      permissionId: params.permissionId,

    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}



/** 用户查询 */
export async function adminUserConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
    login?: String;

  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminUserSearchUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      "criteria": {
        login: params.login || ''
      },
      "pageable": {
        "page": params.current,
        "size": params.pageSize,
      }
    },
    ...(options || {}),
  }).then((res: any) => {
    let result = {
      data: res.content,
      total: res.totalElements,
      success: true,
    };

    if (res.content.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}

/** 用户添加 */
export async function adminUserAddConnect(
  params: {
    login?: number;
    password?: number;
    authorities?: Array;
    email?: String;


  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(adminUserUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      login: params.login,
      password: params.password,
      authorities: params.authorities,
      email: params.email,

    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/** 用户重置 */
export async function adminUserResetConnect(
  params: {
    id?: number;
    login?: string;
    password?: string;
    authorities?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(adminUserUrl, {
    method: 'PUT',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      id: params.id,
      login: params.login,
      password: params.password,
      authorities: params.authorities
    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/** 用户删除 */
export async function adminUserRemoveConnect(arr: Array, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(adminUserUrl, {
    method: 'DELETE',
    data: arr,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 用户权限变更 */
export async function limitsChangeConnect(
  params: {
    id?: number;
    login?: string;
    password?: string;
    authorities?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(limitsChangeUrl, {
    method: 'PUT',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      id: params.id,
      login: params.login,
      password: params.password,
      authorities: params.authorities
    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 获取用户日志 */
export async function OperationLogtConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
    userName?: String;


  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(OperationLogtUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      "criteria": {
        "userName": params.userName || '',
      },
      "pageable": {
        "page": params.current,
        "size": params.pageSize,
      }
    },
    ...(options || {}),
  }).then((res: any) => {
    let result = {
      data: res.content,
      total: res.totalElements,
      success: true,
    };
    if (res.content.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}

/** 数据管理查询 */
export async function modelsDataSearchConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
    name?: String;

  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(modelsUrlSearch, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      "criteria": {
        "name": params.name,
      },
      "pageable": {
        "page": params.current,
        "size": params.pageSize,
      }
    },
    ...(options || {}),
  }).then((res: any) => {
    let result = {
      data: res.content,
      total: res.totalElements,
      success: true,
    };

    if (res.content.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}

/** 数据管理删除 */
export async function modelsDataRemoveConnect(arr: Array, options?: { [key: string]: any }) {
  return request<API.SceneLibrary.Device>(modelsUrl, {
    method: 'DELETE',
    data: arr,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 获取设车型列表 */
export async function searchVehicleConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchVehicle, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params,
    ...(options || {}),
  }).then((res) => {

    console.log(res);

    return res;
  });
}

/** 获取设车型列表 */
export async function partial_searchConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(partial_search, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      // size: params.pageSize,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);

    return res;
  });
}

/** 获取功能列表 */
export async function configurationConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(configuration, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    params: {
      // size: params.pageSize,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/** 获取对比的车辆功能列表 */
export async function modelsConnect(
  params: {
    vIds?: any;
    fIds?: any;
    level?: any;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(models, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      vIds: params.vIds,
      fIds: params.fIds,
      level: params.level,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/**  车型功能迭代 */
export async function searchVehicleFunctionConnect(
  params: {
    vIds?: number;
    fIds?: number;
    time?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchVehicleFunctionUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      vId: params.vIds,
      fId: params.fIds,
      year: params.time,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/**  品牌功能迭代（三个都要选，都是单选） */
export async function searchBrandFunctionConnect(
  params: {
    bId?: string;
    fIds?: number;
    time?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchBrandFunctionUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      bId: params.bId,
      fId: params.fIds,
      year: params.time,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/**  搭载率 */
export async function searchRateConnect(
  params: {
    tIds?: Array;
    fIds?: Array;
    time?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchRateUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      tIds: params.tIds,
      fIds: params.fIds,
      year: params.time,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/**  功能标签 */
export async function searchTagRateConnect(
  params: {
    vIds?: Array;
    tagName?: String;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchTagRateUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      vIds: params.vIds,
      tagName: params.tagName,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/**  功能标签 */
export async function clickTagRateConnect(
  params: {
    data?: any;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(clickTagRateUrl, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params.data,
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}

/** 获取对比的车辆标签列表 */
export async function categoriesConnect(
  params: {
    arr?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(categories, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params.arr,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 查询列表 */
export async function searchTagConnect(
  params: {
    vIds?: Array;
    tIds?: Array;
    tag?: String;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchTag, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      vIds: params.vIds,
      tIds: params.tIds,
      tag: params.tag,
    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  }).catch((res) => {
    console.log(res);
    return res;
  });
}


/** 获取对比的车辆标签列表 */
export async function searchTypeConnect(
  params: {
    arr?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchType, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params.arr,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/** 图片上传 */
export async function imgUploadImage(data: any) {

  return request<any>(ImageUploadUrl, {
    method: 'POST',
    data,
  })
}

/** 数据维护导出 */
export async function vehicleModelExportPost(
  params: {
    data: object
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(vehicleModelExportUrl, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    responseType: 'blob',//一定要加
    data: params.data,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/** 搭载率导出 */
export async function RateExportPost(
  params: {
    data: object
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(RateExportUrl, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    responseType: 'blob',//一定要加
    data: params.data,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 标签分析导出 */
export async function tagRateExportPost(
  params: {
    data: object
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(tagRateExportUrl, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    responseType: 'blob',//一定要加
    data: params.data,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/** 通用导出 */
export async function exportUrlConnect(
  params: {
    data: object
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(exportUrl, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    responseType: 'blob',//一定要加
    data: params.data,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 查询列表 */
export async function searchSingleFunctionConnect(
  params: {
    vIds?: Array;
    fId?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(searchSingleFunction, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      vIds: params.vIds,
      fId: params.fId,
    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}


/** 获取功能列表 */
export async function functionIndustryRatesConnect(
  params: {
    // // query
    // /** 当前的页码 */
    // current?: number;
    // /** 页面的容量 */
    // pageSize?: number;
    id?: String;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(functionIndustryRates, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    params: {
      id: params.id,
      // page: params.current,
    },
    ...(options || {}),
  }).then((res) => {

    console.log(res);
    return res;
  });
}



/** 查询列表 */
export async function exportUrlConnect2(
  params: {
    data: object
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(exportUrl2, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    responseType: 'blob',//一定要加
    data: params.data,
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}

/**xlsx上传 */
export async function datasUploadXlsx(data: any) {
  return request<API.SceneLibrary.Device>(dataxlsxUrl, {
    method: 'POST',
    data,
  })
}

/**xlsx上传 */
export async function usersUploadXlsx(data: any) {
  return request<API.SceneLibrary.Device>(userxlsxUrl, {
    method: 'POST',
    data,
  })
}

/** 查询 车型增删改查 */
export async function vehicleModelsUrlConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
  },
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(vehicleModelsUrl, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    params: {

    },
    ...(options || {}),
  }).then((res: any) => {
    let result = {
      data: res,
      total: res.length,
      success: true,
    };
    console.log(result);

    return result;
  });
}

/** 根据 ID 获取 车型增删改查 */
export async function getConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(vehicleModelsUrl + '/' + id, {
    method: 'GET',
    ...(options || {}),
  });
}


/** 删除 车型增删改查 */
export async function delConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(vehicleModelsUrl + '/' + id, {
    method: 'DELETE',
    ...(options || {}),
  });
}

/** 新增 车型增删改查 */
export async function addConnect(data: API.IOT.Device, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(vehicleModelsUrl, {
    method: 'POST',
    data,
    ...(options || {}),
  });
}

/** 更新 车型增删改查 */
export async function updateConnect(
  data: API.IOT.Device,
  id: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(vehicleModelsUrl + '/' + id, {
    method: 'PUT',
    data: data,
    ...(options || {}),
  });
}
