// @ts-ignore
/* eslint-disable */
import { request } from '@umijs/max';
import { message } from 'antd';

const adminRolassignPermission = '/api/admin/user/assignPermission'; // 角色分配权限

// 查询类别
const adminUserUrl = '/api/core/org/user'; //用户管理
const adminRolesUrl = '/api/core/org/role'; // 角色管理
const adminResourceUrl = '/api/core/org/permission'; //资源管理
const adminResourceChildUrl = '/api/core/org/resource'; //资源管理子集
const adminResourceRoot = '/api/core/org/resource/tree/root'; //资源管理根目录


/** 用户查询 */
export async function adminUserConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
    login?: String;
  },

  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminUserUrl, {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      size: params.pageSize,
      page: params.current - 1,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}


/** 用户更新 */
export async function adminUserUpdateConnect(
  id?: any,
  data?: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminUserUrl + '/' + id, {
    method: 'PUT',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    data: data,
    ...(options || {}),
  }).then((res: any) => {

    return res;
  });
}

/** 用户删除 */
export async function adminUserRemoveConnect(
  id: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminUserUrl + '/' + id, {
    method: 'DELETE',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    ...(options || {}),
  }).then((res: any) => {
    return res;
  });
}

/** 用户新增 */
export async function adminUserAddConnect(
  data: any,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminUserUrl, {
    method: 'POST',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    data: data,
    ...(options || {}),
  }).then((res: any) => {
    return res;
  });
}


/** 角色查询 */
export async function adminRolesConnect(
  params: {
    // query
    /** 当前的页码 */
    current?: number;
    /** 页面的容量 */
    pageSize?: number;
    login?: String;
  },

  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminRolesUrl, {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      size: params.pageSize,
      page: params.current - 1,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}

/** 获取角色许可列表 */
export async function adminUserRoleIdConnect(id: string, options?: { [key: string]: any }) {
  return request<API.IOT.Device>(adminRolesUrl + '/' + id + '/permissions', {
    method: 'GET',
    ...(options || {}),
  });
}


/** 获取许可资源列表 */
export async function adminResourceConnect(
  id: Number,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminResourceUrl + '/' + id + '/resources', {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      // size: params.pageSize,
      // page: params.current - 1,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}

/** 获取许可资源列表 */
export async function adminResourceChildConnect(
  id: Number,
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminResourceChildUrl + '/' + id + '/children', {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      // size: params.pageSize,
      // page: params.current - 1,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}


/** 获取许可资源列表 */
export async function adminResourceRootConnect(
  options?: { [key: string]: any },
) {
  return request<API.IOT.Device>(adminResourceRoot, {
    method: 'GET',
    headers: {
      'content-type': 'application/json; charset=UTF-8'
    },
    params: {
      // size: params.pageSize,
      // page: params.current - 1,
    },
    ...(options || {}),
  }).then((res: any) => {

    let result = {
      data: res,
      total: res.length,
      success: true,
    };

    if (res.length === 0) {
      message.warning('未查询到数据');
    } else {
      message.success('查询完成');
    }

    console.log(result);
    return result;
  });
}


/** 角色权限修改分配权限        */
export async function adminRolassignPermissionConnect(
  params: {
    roleId?: String;
    permissionId?: Array;
  },
  options?: { [key: string]: any },
) {
  return request<API.SceneLibrary.Device>(adminRolassignPermission, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: {
      roleId: params.roleId,
      permissionId: params.permissionId,

    },
    ...(options || {}),
  }).then((res) => {
    console.log(res);
    return res;
  });
}
