import React, { useState, useEffect, useRef, Children } from 'react';
import { Card, Col, Row, Avatar, List, Drawer, Modal, Empty, message, Carousel } from 'antd';
import { useNavigate, } from 'react-router-dom';
import _ from 'lodash';
import './style.less'
const { Meta } = Card;
import images5 from './images/分类.png'
import images7 from './images/学生管理.png'
import images8 from './images/标注考试.png'
import images9 from './images/训练管理.png'
import images10 from './images/成绩查询.png'

const teacherData = [
  {
    id: 1,
    name: '用户管理',
    icon: images7,
    children: [
      {
        id: 1,
        path: '/Management/ClassManagement',
        name: '班级管理',
      },
      {
        id: 2,
        name: '学生管理',
        path: '/Management/StudentManagement',
      },
    ]
  },
  {
    id: 2,
    name: '标注考试',
    icon: images8,
    path: '/MarkingExams',
  },
  {
    id: 3,
    name: '训练管理',
    icon: images9,
    path:  '/TrainingManagement',
  },
  {
    id: 4,
    name: '成绩查询',
    icon: images10,
    path: '/PerformanceManagement',
  },
]
const ClassifyPage = () => {
  const carouselRef = useRef(null) as any;
  const navigate = useNavigate();
  const [cardData, setCardData] = useState([]) as any;
  const [listData, setListData] = useState([]) as any;
  const [currentSlide, setCurrentSlide] = useState(0);


  useEffect(() => {
    judgingRoles() // 判断角色
    return () => { };

  }, []);

  // 判断角色

  const judgingRoles = () => {
    setCardData(teacherData)
  }

  const goToPath = (pathUrl: any, pathObject: any) => {
    navigate(pathUrl, { state: { object: pathObject } });
  };

  const showDrawer = (item: any) => {
    carouselRef.current.next()
    setListData(item?.children || [])
  };

  const onAfterChange = (currentSlide: number) => {
    setCurrentSlide(currentSlide)
  };
  return (
    <>
      <div className="classify">
        <div className='carousel'>
          <div className='back' style={{ display: currentSlide > 0 ? 'block' : 'none' }} onClick={() => { carouselRef.current.prev(); }}></div>
          <Carousel afterChange={onAfterChange} arrows={false} autoplay={false} dots={false} ref={carouselRef}  >
            <div>
              <Row gutter={[64, 64]} justify="space-evenly">
                {cardData.map((item: any) => {
                  return <Col span={10} key={`a-${item.id}`}>
                    <Card
                      onClick={() => {
                        if (item.children) {
                          showDrawer(item)
                        } else {
                          navigate(item.path);
                        }
                      }}
                      className="classifyCard"
                    >
                      <Meta
                        avatar={<Avatar src={item.icon} />}
                        title={item.name}
                        description={item.name}
                      />
                    </Card>
                  </Col>
                })}
              </Row>
            </div>
            <div>
              <Row gutter={[64, 64]} justify="space-evenly">
                {listData.map((item: any) => {
                  return <Col span={10} key={`a-${item.id}`}>
                    <Card
                      onClick={() => {
                        navigate(item.path);
                      }}
                      className="classifyCard"
                    >
                      <Meta
                        avatar={<Avatar src={images5} />}
                        title={item.name}
                        description={item.name}
                      />
                    </Card>
                  </Col>
                })}
              </Row>
            </div>
          </Carousel>
        </div>
      </div>
    </>
  );
}
export default ClassifyPage;
