// import Upload from '@/components/Upload';
import { getUser, imgUploadImage, updateUser } from '@/services/auth/user';
import { PlusOutlined } from '@ant-design/icons';
import { ProForm, ProFormText, ProFormTextArea } from '@ant-design/pro-components';
import { message, Upload } from 'antd';
import type { RcFile, UploadFile } from 'antd/es/upload/interface';
import React, { useEffect, useRef, useState } from 'react';
import { history } from 'umi';
import styles from './BaseView.less';

const BaseView: React.FC = () => {
  const formRef = useRef<any>();
  const [currentUser, setCurrentUser] = useState<any>({});
  const [fileList, setFileList] = useState<UploadFile[]>([]);
  const [imageSrc, setImageSrc] = useState('');
  const [httpUrl, setHttpUrl] = useState('http://192.168.0.50:8080/');
  const limitsData = [
    { label: '管理员', value: 'ROLE_ADMIN' },
    { label: '维护员', value: 'ROLE_WEIHU' },
    { label: '普通用户', value: 'ROLE_USER' },
  ]

  useEffect(() => {
    userInfo();
  }, []);

  const userInfo = () => {
    const username = window.sessionStorage.getItem('username') as any;



    getUser(username).then((res: any) => {
      formRef?.current?.setFieldsValue({
        login: res.login,
        email: res.email,
        password: '******',
        firstName: limitsData.filter((item) => item.value === res.authorities[0])[0].label,
      });

      if (res.fristLogin) {
        message.warning('首次登录，请先修改密码');
      }
    });


    // let imageSrc = fileList as any;
    // imageSrc.url = httpUrl + res.user_logo;

    // setFileList([imageSrc]);
  };

  // 更新
  const handleFinish = async (values: any) => {
    let obj = { ...(currentUser || {}), ...values };
    let User = JSON.parse(window.sessionStorage.getItem('User') as any);
    obj.id = User.id
    if (values?.password.length < 6) {
      message.warning('密码不能少于6位');
      return false
    }

    if (values?.email.length < 6) {
      message.warning('联系方式不能少于6位');
      return false
    }

    updateUser(obj).then((res) => {
      history.push('/user/welcome');
      message.success('更新基本信息成功');
    })

  };

  // 上传前
  const beforeUpload = (file: UploadFile<any>) => {
    handleUpload(file);
    return false;
  };

  // 上传
  const handleUpload = (file: any) => {
    const formData = new FormData();
    formData.append('file', file as RcFile);
    // You can use any AJAX library you like
    imgUploadImage(formData).then((res: any) => {
      let imageSrc = file;
      let message = JSON.parse(res).message;
      imageSrc.url = `${httpUrl}${message}`;
      setFileList([imageSrc]);
      setImageSrc(message);
    });
  };



  const uploadButton = (
    <div>
      <PlusOutlined />
      <div style={{ marginTop: 8 }}>Upload</div>
    </div>
  );

  return (
    <div className={styles.baseView}>
      <>
        <div className={styles.left}>
          <ProForm
            formRef={formRef}
            layout="vertical"
            onFinish={handleFinish}
            hideRequiredMark
          >
            <ProFormText
              width="md"
              name="login"
              label="用户名"
              rules={[
                {
                  required: true,
                  message: '请输入用户名',
                },
              ]}
            />
            <ProFormText.Password
              width="md"
              name="password"
              label="密码"
              rules={[
                {
                  required: true,
                  message: '请输入密码',
                },
              ]}
            />
            <ProFormText
              width="md"
              name="email"
              label="联系方式"
              rules={[
                {
                  required: true,
                  message: '请输入联系方式',
                },
              ]}
            />
            <ProFormText
              width="md"
              name="firstName"
              disabled
              label="角色"
              rules={[
                {
                  required: true,
                  message: '角色!',
                },
              ]}
            />
          </ProForm>
        </div>
        {/* <div className={styles.right}>
          <>
            <div className={styles.avatar_title}>头像</div>
            <div className={styles.avatar}>
              <ProForm.Group>
                <Upload
                  name="file"
                  listType="picture-card"
                  beforeUpload={beforeUpload}
                  onRemove={onRemove}
                  maxCount={1}
                  fileList={fileList}
                  action="/polls/user/upload"
                >
                  {fileList.length >= 1 ? null : uploadButton}
                </Upload>
              </ProForm.Group>
            </div>
          </>
        </div> */}
      </>
    </div>
  );
};

export default BaseView;
