import {
  ProTable,
} from '@ant-design/pro-components';
import { useRef, useState, useEffect } from 'react';
import { Spin, Tag } from 'antd';
import { PageContainer } from '@ant-design/pro-layout';
import { OperationLogtConnect } from '@/services/SearchVehicle/searchVehicle';


export default () => {
  const actionRef = useRef<any>();
  const [spinning, setSpinning] = useState<any>(false);
  const [pageSize, setPageSize] = useState<any>(10);

  useEffect(() => {
    return () => {
    };
  }, []);


  const columns = [
    { align: 'center', title: "序号",search: false, width: 68, render: (text, record, index) => `${index + 1}`, },
    {
      // search: false,
      title: '维护人',
      align: 'center',
      dataIndex: 'userName',
      render: (text: any, item: any) => {
        return <div>{item?.userName}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '维护日志',
      render: (item: any) => {
        return <div> {item?.details}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '维护行为',
      render: (item: any) => {
        return <div>{item?.action}</div>
      },
    },
    {
      search: false,
      align: 'center',
      title: '维护时间',
      render: (item: any) => {
        return <div> {item?.timestamp}</div>
      },
    },
  ];


  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <ProTable
          columns={columns}
          actionRef={actionRef}
          cardBordered
          request={OperationLogtConnect}
          columnsState={{
            persistenceKey: 'pro-table-singe-demos',
            persistenceType: 'sessionStorage',
            onChange(value: any) {
              console.log('value: ', value);
            },
          }}
          scroll={{ y: 480 }}
          rowKey="id"
          // search={false}
          options={{
            setting: {
              listsHeight: 400,
            },
          }}
          pagination={{
            pageSize: pageSize,
            showSizeChanger: true,
            onChange: (page: any, pageSize: any) => setPageSize(pageSize),
          }}
          dateFormatter="string"
          toolBarRender={() => [

          ]}
        />
      </Spin>
    </PageContainer>
  );

};