import { PlusOutlined } from '@ant-design/icons';
import {
  ProTable,
  ProForm,
  ProFormText,
  ModalForm,
} from '@ant-design/pro-components';
import { Button, Card, } from 'antd';
import { useRef, useState, useEffect } from 'react';
import { adminResourceConnect, } from '@/services/Limits/index';
import { Popconfirm, message } from 'antd';
import React from 'react';
import { Tree } from 'antd';
import { PageContainer } from '@ant-design/pro-layout';
import { curdSet } from '@/utils/index';  //页面权限配置表


export default () => {

  const formRef = useRef<any>();
  const [modalVisit, setModalVisit] = useState(false);
  const [modalVisit1, setModalVisit1] = useState(false);
  const [addVis, setAddVis] = useState(true);
  const [removeVis, setRemoveVis] = useState(true);
  const [editVis, setEditVis] = useState(true);
  const [searchVis, setSearchVis] = useState(true);
  const [limitsVis, setLimitsVis] = useState(true);
  const [treeData, setTreeData] = useState([]);
  //设置是否选中
  const [checkedKeys, setCheckedKeys] = useState<React.Key[]>([]);
  //设置是否展开
  const [expandedKeys, setExpandedKeys] = useState<React.Key[]>([1, 2, 3, 4, 5, 6, 7]);
  const [roleId, setRoleId] = useState<any>(null);

  useEffect(() => {

  }, [])



  // 查看详情
  const onView = (record: any) => {
    setTimeout(() => {
      formRef?.current?.setFieldsValue(record);
    }, 100)
  };

  const columns = [
    { align: 'center', search: false, title: "序号", width: 68, render: (text, record, index) => `${index + 1}`, },
    {
      dataIndex: 'code',
      title: '角色名称',
      align: 'center',
    },
    {
      dataIndex: 'createdDate',
      title: '创建时间',
      align: 'center',
      search: false,
    },
    {
      title: '操作',
      dataIndex: 'x',
      align: 'center',
      valueType: 'option',
      render: (_, record) => {
        return [
          <> <Button
            key="editable"
            type="primary"
            style={!editVis ? {} : { background: '#2db7f5', border: 'none' }}
            disabled={!editVis}
            onClick={async (e) => {
              setModalVisit1(true);
              await onView(record);
            }}
          >
            修改
          </Button> </>,
          <>
            <Popconfirm
              title="确认删除？"
              onConfirm={() => { }}
              onCancel={() => { }}
              disabled={!removeVis}
            >

              <Button
                key="remove"
                type="primary"
                danger
                disabled={!removeVis}
              >
                删除
              </Button>
            </Popconfirm>
          </>
        ];
      },
    },
  ];





  return (
    <PageContainer>
      <ProTable
        columns={columns}
        request={adminResourceConnect}
        rowKey="id"
        cardBordered
        pagination={{
          showQuickJumper: true,
        }}
        search={searchVis ? {
          labelWidth: 'auto',
        } : false}
        toolBarRender={() => [
          <>
            <Button
              key="button"
              icon={<PlusOutlined />}
              type="primary"
              disabled={!addVis}
              onClick={() => {
                setModalVisit1(true);
              }}
            >
              新建
            </Button>
          </>
        ]}
      />
    </PageContainer>
  );

};