import { Empty, Modal, Card, Collapse, Row, Col, Spin } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import { searchSingleFunctionConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';
const { Panel } = Collapse;
export default () => {

  const [data, setData] = useState<any>([]);
  const [spinning, setSpinning] = useState<any>(false);

  const submit = (type: string, value: any) => {
    console.log(type, value);
    let vIds = value?.vehicle?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    })

    let fId = value?.function?.value

    if (!vIds || !fId) {
      Modal.warning({
        content: '请先选择车型和功能',
        centered: true
      });
      return
    }
    setSpinning(true)

    searchSingleFunctionConnect({ vIds: vIds, fId: fId }).then((res) => {
      console.log(res);
      setData(res)
      setSpinning(false)

    })

  };

  const onChange = (key: string | string[]) => {
    console.log(key);
  };



  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>

        <SearchVehicle
          config={
            {
              submitter: true,
              vehicle: true,
              function: true,
              condition: false,
              functionmultiple: false,
              vehicleUrl: 'partial_searchConnect'
            }
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* table主体 */}
        <Collapse defaultActiveKey={['0']} onChange={onChange}>
          {
            data.map((item: any, i: any) => {
              return <Panel header={item.title} key={i}>
                <Row gutter={16}>
                  {item.children.map((item2: any, i2: any) => {
                    return <Col span={8}>
                      <Card title={item2.label} bordered={false} style={{ border: '1px solid #d9d9d9', marginBottom: 10 }} headStyle={{ borderBottom: '1px solid #d9d9d9 ' }}>
                        {item2.note}
                      </Card>
                    </Col>
                  })}

                </Row>
              </Panel>
            })
          }
        </Collapse>
        <Empty style={{ display: data.length > 0 ? 'none' : "block" }} />
      </Spin>

    </PageContainer>
  );
};
