import { Modal, Button, Card, Collapse, Popconfirm, Tabs, Tag } from 'antd';
import { useRef, useState } from 'react';
import Contrast from '@/components/Contrast';
import SearchVehicle from '@/components/SearchVehicle';
import { modelsConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';

export default () => {

  const [data, setData] = useState<any>([]);

  const submit = (type: string, value: any) => {
    console.log(type, value);
    let vIds = value?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    })

    console.log(vIds);


    if (!vIds) {
      Modal.warning({
        content: '请先选择车型',
        centered: true
      });
      return
    }


    modelsConnect({ vIds: vIds }).then((res) => {
      console.log(res);
      setData(res)
    })
  };

  return (
    <PageContainer>
      <SearchVehicle
        config={
          {
            submitter: false,
            vehicle: true,
            functionmultiple: true,
            vehicleUrl: 'searchVehicleConnect'
          }}
        submit={submit} ></SearchVehicle >
      <Contrast data={data}></Contrast>
    </PageContainer>
  );
};
