import { Modal, message, Input, Collapse, Popconfirm, notification, Spin } from 'antd';
import { useEffect, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import Contrast from '@/components/Contrast';
import { modelsConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';

export default () => {

  const [data, setData] = useState<any>([]);
  const [spinning, setSpinning] = useState<any>(true);
  const [functionTags, setFunctionTags] = useState<any>(true);

  
  useEffect(() => {
    setTimeout(() => {
      setSpinning(false)
    }, 1000);
  }, []);
  const submit = (type: string, value: any) => {
    console.log(type, value);
    let vIds = value.vehicle ? value.vehicle?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    }) : null
    console.log(vIds);

    let level = value.level ? value.level : null
    console.log(level);

    let fIds = value.function ? value.function?.map((item: any, i: any) => {
      return item.value
    }) : null
    console.log(fIds);

    if (!vIds && !level) {
      Modal.warning({
        content: '请选择车型或级别',
        centered: true
      });
      return
    }
    // if (!vIds || vIds.length < 1) {
    //   Modal.warning({
    //     content: '请先选择车型和功能',
    //     centered: true
    //   });
    //   return
    // }

    if (fIds?.length > 100) {
      openNotification('topRight', '功能选择超过100数量，可能会导致查询时间过长')
    }

    setSpinning(true)
    modelsConnect({ vIds: vIds, fIds: fIds, level: level }).then((res) => {
      console.log(res);
      setSpinning(false)
      message.success('查询完成');
      setData(res)
    }).catch((error) => {
      console.log(error);
      message.error('请求出错，请重新查询');
      setSpinning(false)
    })

  };

  const openNotification = (placement: any, message: String) => {
    notification.info({
      message: <span style={{ fontSize: 12 }}>{message}</span>,
      placement,
    });
  };

  return (
    <PageContainer>
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <SearchVehicle
          config={
            {
              level: true,
              submitter: true,
              vehicle: true,
              function: true,
              tags: true,
              functionmultiple: true,
              vehicleUrl: 'searchVehicleConnect',
              tagsUrl: 'tags',
              multiple: true,
            } as any
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* table主体 */}
        <Contrast data={data} FunctionTags={functionTags}></Contrast>
      </Spin>
    </PageContainer>
  );
};
