import { Modal, Empty, message, Collapse, notification, Tooltip, Spin } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import AnalysisList from '@/components/AnalysisList';
import { searchRateConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';
import CountContext from '@/components/Common/CreateContext'
import Line from '@/components/Line';


const configConst = {
  data: [],
  xField: 'year',
  yField: 'value',
  seriesField: 'category',
  // tooltip: {
  //   showTitle:true,
  //   title:"双击展开"
  // },
  yAxis: {
    label: {
      // 数值格式化为千分位
      formatter: (v: any) => `${v}`,
    },
  },
};
let callbackClick = [] as any;

export default () => {
  const [config, setConfig] = useState<any>(configConst);
  const [data, setData] = useState<any>([]);
  const [clickData, setClickData] = useState<any>([]);
  const [spinning, setSpinning] = useState<any>(false);
  const [imageUrl, setImageUrl] = useState("");
  const [screenshot, setScreenshot] = useState(false); // 截图开关 


  const submit = (type: string, value: any) => {
    console.log(type, value);
    let tIds = value?.vehicleLarge?.map((item: any, i: any) => {
      return parseInt(item[item.length - 1])
    })
    let fIds = value?.function?.map((item: any, i: any) => {
      return item.value
    })

    let time = value?.time?.map((item: any, i: any) => {
      return item
    }).map(Number)


    if (!time || !fIds) {
      Modal.warning({
        content: '请先选择功能和时间',
        centered: true
      });
      return
    }
    if (fIds?.length > 100) {
      openNotification('topRight', '功能选择超过100数量，可能会导致查询时间过长')
    }
    setSpinning(true)
    searchRateConnect({ tIds: tIds || [], fIds: fIds, time: time }).then((res: any) => {
      console.log(res);
      let { echart, click } = res as any

      message.success('查询完成');
      setSpinning(false)
      setData(echart)
      callbackClick = click

      let configData = config
      configData.data = echart
      setConfig({ ...configData })
      setTimeout(() => {
        setScreenshot(true)
      }, 1000);
    }).catch((error) => {
      console.log(error);
      message.error('请求出错，请重新查询');
      setSpinning(false)
    })

  };

  const openNotification = (placement: any, message: String) => {
    notification.info({
      message: <span style={{ fontSize: 12 }}>{message}</span>,
      placement,
    });
  };

  const htmlImage = (image: any) => {
    image.then((res: any) => {
      setImageUrl(res)
    })
  }

  const dbclick = (year: any) => {
    console.log(callbackClick);
    console.log(year);
    setClickData(callbackClick[year])
  }

  return (
    <PageContainer
      header={{
        breadcrumb: {},
      }}
    >
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <SearchVehicle
          config={
            {
              importEchar: 'carry',
              imageUrl: imageUrl,
              submitter: true,
              vehicleLarge: true,
              function: true,
              time: true,
              multiple: true,
              vehicleUrl: 'vehicleCategories',
              timeUrl: 'searchYear',
            } as any
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        <div style={{ marginBottom: 20, background: '#fff', padding: 20 }}>
          <div style={{ display: data.length > 0 ? 'block' : 'none', }}>
            <h4>车型数量</h4>
            <Tooltip title={'双击展开'}>
              <div >
                <CountContext.Provider value={htmlImage}>
                  <Line config={config} screenshot={screenshot} dbclick={(e: any) => { dbclick(e) }}></Line>
                </CountContext.Provider>
              </div>
            </Tooltip>
            {/* table主体 */}
            <AnalysisList data={clickData} type="LoadRateAnalysis"></AnalysisList>

          </div>
          <Empty style={{ display: data.length > 0 ? 'none' : "block" }} />
        </div>
      </Spin>
    </PageContainer>
  );
};
