import { Modal, message, Input, Collapse, Carousel, Tabs, Spin } from 'antd';
import { useRef, useState } from 'react';
import SearchVehicle from '@/components/SearchVehicle';
import Contrast from '@/components/Contrast';
import { searchVehicleFunctionConnect, searchBrandFunctionConnect } from '@/services/SearchVehicle/searchVehicle';
import { PageContainer } from '@ant-design/pro-layout';

export default () => {

  const [data, setData] = useState<any>([]);
  const [spinning, setSpinning] = useState<any>(false);



  const submit = (type: string, value: any) => {
    console.log(type, value);
    if (value?.vehiclebrand === '') {
      let vIds = value.vehicle ? parseInt(value.vehicle[value?.vehicle.length - 1]) : null;
      let fIds = value.function ? parseInt(value?.function?.value) : null;
      // let time = value.time ? parseInt(value?.time) : null

      if (!vIds || !fIds) {
        Modal.warning({
          content: '请先选择车型和功能',
          centered: true
        });
        return
      }

      setSpinning(true)
      searchVehicleFunctionConnect({ vIds: vIds, fIds: fIds, }).then((res) => {
        console.log(res);
        message.success('查询完成');
        setSpinning(false)
        setData(res)
      }).catch((error) => {
        console.log(error);
        message.error('请求出错，请重新查询');
        setSpinning(false)
      })
    } else if (value?.vehicle === '') {
      let bId = value.vehiclebrand ? value?.vehiclebrand[value?.vehiclebrand.length - 1] : null;
      let fIds = value.function ? parseInt(value?.function?.value) : null;
      // let time = value.time ? parseInt(value?.time) : null


      if (!bId || !fIds) {
        Modal.warning({
          content: '请先选择品牌和功能',
          centered: true
        });
        return
      }

      setSpinning(true)
      searchBrandFunctionConnect({ bId: bId, fIds: fIds, }).then((res) => {
        console.log(res);
        setSpinning(false)
        message.success('查询完成');
        setData(res)
      }).catch((error) => {
        console.log(error);
        message.error('请求出错，请重新查询');
        setSpinning(false)
      })
    }
  };


  return (
    <PageContainer
      header={{
        breadcrumb: {},
      }}
    >
      <Spin tip="Loading..." size="large" spinning={spinning}>
        <SearchVehicle
          config={
            {
              submitter: true,
              vehicle: true,
              vehiclebrand: true,
              function: true,
              // time: true,
              vehicleUrl: 'searchVehicleConnect',
              brandUrl: 'vehiclebrand',
              multiple: false,
              timeUrl: 'searchYear'
            } as any
          }
          data={data}
          submit={submit}
          setSpinning={(e: boolean) => { setSpinning(e) }}
        ></SearchVehicle>
        {/* table主体 */}
        <Contrast data={data} FunctionTags={false}></Contrast>
      </Spin>
    </PageContainer>
  );
};

