
import { ProFormCascader, ProForm, ProFormText } from '@ant-design/pro-components';
import { searchVehicleConnect, partial_searchConnect } from '@/services/SearchVehicle/searchVehicle';

import React, { useState, useRef, useEffect } from 'react';


interface Option {
  value: string | number;
  label: string;
  children?: Option[];
}




const App: React.FC = (props: any) => {


  const [options, setOptions] = useState<any>([])




  useEffect(() => {

    if (props.vehicleUrl === 'partial_searchConnect') {
      partial_searchConnect({}).then((res) => {
        console.log(res);
        setOptions(res)
      })
    }

    if (props.vehicleUrl === 'searchVehicleConnect') {
      searchVehicleConnect({}).then((res) => {
        console.log(res);
        setOptions(res)
      })
    }

  }, [props.vehicleUrl]);
  return (
    <ProForm.Group >
      <ProFormCascader
        {...props}
        fieldProps={{
          options: options,
          showArrow: true,
          filterTreeNode: true,
          showSearch: true,
          dropdownMatchSelectWidth: false,
          labelInValue: true,
          autoClearSearchValue: true,
          multiple: true,
          treeLine: true,
          treeCheckable: true,
          placeholder: "请选择车型",
          onChange: props.change,
          showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
        }}
      />
    </ProForm.Group>
  );
};

export default App;