
import { ProFormCascader, ProForm, ProFormRadio } from '@ant-design/pro-components';
import { Spin } from 'antd';
import { searchVehicleConnect, partial_searchConnect, vehicleCategoriesConnect, vehiclebrandConnect, vehicletimeConnect } from '@/services/SearchVehicle/searchVehicle';
import React, { useState, useRef, useEffect } from 'react';

const App: React.FC = (props: any) => {


  const [options, setOptions] = useState<any>([])
  const [optionsLabel, setOptionsLabel] = useState<any>([])
  const [radioValue, setradioValue] = useState<any>('')
  const [spinning, setSpinning] = useState<any>(true)




  useEffect(() => {

    if (props.vehicleUrl === 'partial_searchConnect') {
      partial_searchConnect({}).then((res) => {
        console.log(res);
        setOptions(res)
        setSpinning(false)
      })
    }

    if (props.vehicleUrl === 'searchVehicleConnect') {
      let searchObj = props.searchObj ? props.searchObj : {}

      searchVehicleConnect(searchObj).then((res) => {
        console.log(res);
        let resArray = traverseArray(res)
        console.log(resArray);

        setOptionsLabel(resArray)
        // setradioValue(resArray[0]?.value)
        setOptions(resArray)
        setSpinning(false)
      })
    }

    if (props.vehicleUrl === 'vehicleCategories') {
      vehicleCategoriesConnect({}).then((res) => {
        console.log(res);
        let resArray = addLabelArray(res)
        console.log(resArray);
        setOptions(resArray)
        setSpinning(false)
      })
    }

    if (props.vehicleUrl === 'vehiclebrand') {
      vehiclebrandConnect({}).then((res) => {
        console.log(res);
        setOptions(res)
        setSpinning(false)
      })
    }

    if (props.vehicleUrl === 'searchYear') {
      vehicletimeConnect({}).then((res) => {
        console.log(res);
        setOptions(res)
        setSpinning(false)
      })
    }

    if (props.vehicleUrl === 'searchVehiclelabel') {
      setOptions(['功能标签', '人群标签', '场景标签', '环境标签'])
      setSpinning(false)
    }

    if (props.vehicleUrl === 'tags') {
      setOptions([
        { value: 1, label: '安全' },
        { value: 2, label: '便利' },
        { value: 3, label: '个性' },
        { value: 4, label: '基础' },
        { value: 5, label: '舒适' },
        { value: 6, label: '性能' },
        { value: 7, label: '娱乐' },
        { value: 8, label: '造型' },
        { value: 9, label: '智能' },])
      setSpinning(false)
    }


  }, [props.vehicleUrl, props.timeUrl, props.searchObj]);

  // 递归遍历数组和它的children属性下的数组判断它的children属性值是null还是空数组 是空数组的话给他添加一个disabled: true的属性，null的话不添加disabled属性
  const traverseArray = (arr: any) => {
    for (let i = 0; i < arr.length; i++) {
      if (arr[i].children) {
        if (Array.isArray(arr[i].children) && arr[i].children.length === 0) {
          arr[i].disabled = true;
        } else if (Array.isArray(arr[i].children)) {
          console.log(arr[i].children);

          let bool = arr[i].children.every((item: any) => {
            return item?.children?.length === 0
          })
          if (bool) {
            arr[i].disabled = true;
          }
        }
        traverseArray(arr[i].children); // 递归遍历子数组  
      }
    }


    // 二次判断一级菜单
    for (let index = 0; index < arr.length; index++) {
      const element = arr[index];
      if (element.children) {
        let bool = element.children.every((item: any) => {
          return item?.disabled === true
        })
        if (bool) {
          element.disabled = true;
        }
      }
    }

    return arr;
  }


  const addLabelArray = (arr: any) => {
    for (let i = 0; i < arr.length; i++) {
      let children = arr[i].children
      let label = arr[i].label

      for (let index = 0; index < children.length; index++) {
        const element = children[index];
        element.label = element.label + '(' + label + ')'
      }
    }
    return arr;
  }

  const onChangeRadio = (val: any) => {
    setradioValue(val.target.value)
    setOptions(optionsLabel.filter((item: any) => item.value === val.target.value)[0]?.children)
  }

  return (
    <ProForm.Group >
      <Spin spinning={spinning}>
        <ProFormCascader
          {...props}
          fieldProps={{
            options: options,
            showArrow: true,
            filterTreeNode: true,
            showSearch: true,
            dropdownMatchSelectWidth: false,
            labelInValue: true,
            autoClearSearchValue: true,
            multiple: props.multiple,
            treeLine: true,
            treeCheckable: true,
            placeholder: "请选择车型",
            expandTrigger: 'hover',
            // maxTagCount: 5,
            onChange: props.change,
            suffixIcon: false,
            dropdownHeight: 10,
            showCheckedStrategy: 'SHOW_CHILD', // 显示选中值的模式 SHOW_ALL:显示所有选中的节点（包括父节点）,SHOW_CHILD:只显示选中的子节点,SHOW_PARENT:显示选中的节点及其父节点
          }}
        />
      </Spin>
      {/* {props.vehicleUrl === 'searchVehicleConnect' ? <ProFormRadio.Group
        name="vehicleGroup"
        fieldProps={{
          value: radioValue,
          options: optionsLabel,
          onChange: (e: any) => { onChangeRadio(e) }

        }}
      /> : ''} */}

    </ProForm.Group>
  );
};

export default App;