import BoxContent from '@/components/Common/BoxContent'
import React, { useRef, useState, useEffect } from 'react';
import { Pie } from '@ant-design/plots';
import './index.less'


const DemoPie = (props: any) => {



  const data = [] as any;
  const config = {
    appendPadding: 10,
    data,
    angleField: 'value',
    colorField: 'type',
    radius: 0.9,
    label: {
      type: 'inner',
      offset: '-30%',
      content: ({ percent }) => `${(percent * 100).toFixed(0)}%`,
      style: {
        fontSize: 14,
        textAlign: 'center',
      },
    },
    interactions: [
      {
        type: 'element-active',
      },
    ],
  };


  const [options, setOptions] = useState<any>(config)
  const plotRef = useRef() as any


  useEffect(() => {
    const plot = plotRef.current.getChart();
    //console.log(plot.options.data);
    //开始绑定事件
    //因为绑定事件后，事件内获取不到Type的最新值，故在这进行模拟
    let i = 1
    plot.on('element:click', (evt: any) => {
      console.log(evt.data.data);
    });
  }, []);


  useEffect(() => {
    if (props.data) {
      console.log(props.data);
      let obj = options
      obj.data = props.data
      setOptions({ ...obj })
    }
  }, [props.data]);


  return (
    <>
      <BoxContent {...props}>
        <div id="Pie2">
          <Pie className="Pie2" {...options} ref={plotRef} />
        </div>
      </BoxContent>
    </>
  )
}
export default React.memo(DemoPie)
