import BoxContent from '@/components/Common/BoxContent'
import { Line } from '@ant-design/plots'
import React, { useEffect, useState, useRef } from 'react'

import './index.less'
const DemoLine = (props: any) => {
  const plotRef = useRef(null) as any;
  let year = '';

  useEffect(() => {
    const plot = plotRef.current.getChart();
    // plot 添加点击事件,整个图表区域
    plot.on('plot:dblclick', (args:any) => {
      props.dbclick(year)
    });

    // 给 tooltip 添加点击事件
    plot.on('tooltip:show', (args:any) => {
      year = args?.data?.title
    });

  }, []);

  return (
    <>
      <BoxContent {...props}>
        <div id="Line">
          <Line ref={plotRef} className="Line" {...props?.config} />
        </div>
      </BoxContent>
    </>
  )
}
export default React.memo(DemoLine)
