
import { Tabs, Collapse, Checkbox, Tooltip, Empty, Table, Tag } from 'antd';
import type { ColumnsType } from 'antd/es/table';
import { LeftOutlined, RightOutlined, } from '@ant-design/icons';
import React, { useState, useRef, useEffect } from 'react';
import Pie2 from '@/components/Pie2';
import './index.less'

const { Panel } = Collapse;


const App: React.FC = (props: any) => {
  const [items, setItems] = useState([

  ]);



  const columns = [
    {
      title: '标签',
      dataIndex: 'tagType',
      key: 'tagType',
    },
    {
      title: '功能',
      dataIndex: 'funName',
      key: 'funName',
    },
    {
      title: '功能描述',
      dataIndex: 'funDesc',
      key: 'funDesc',
    },
    {
      title: '功能定义',
      key: 'funDefinition',
      dataIndex: 'funDefinition',
    },
  ];

  useEffect(() => {
    init() // 初始化
  }, []);

  useEffect(() => {
    if (props.data) {
      setItems(props.data)
    }
  }, [props.data]);




  // 初始化
  const init = () => {

  }

  return (
    <div id="LabelContent">
      <Collapse defaultActiveKey={['0']} style={{ display: items.length > 0 ? 'block' : 'none' }} >
        {items?.map((item1: any, i: any) => {
          return (
            <Panel header={item1.label} key={i}>
              <div className='label'>
                {item1?.tagData?.map((item2: any, i2: any) => {
                  return (
                    <div key={i2}>
                      <p>{item2?.label}</p>
                      <Pie2 data={item2?.data}></Pie2>
                    </div>
                  )
                })
                }
              </div>
              <Table columns={columns} dataSource={item1.functionDate} />
            </Panel>
          )
        })
        }
      </Collapse>
      <Empty style={{ display: items.length > 0 ? 'none' : "block" }} />
    </div >
  );
};

export default App;