import BoxContent from '@/components/Common/BoxContent'
import { Gauge } from '@ant-design/plots'

import React, { useEffect, useRef } from 'react'
import './index.less'

const DemoGauge = (props: any) => {
  const ticks = [0, 1 / 3, 2 / 3, 1]
  const color = ['#F4664A', '#FAAD14', '#30BF78']
  const graphRef = useRef(null) as any
  const config = {
    percent: 0,
    innerRadius: 0.8,
    type: 'meter',
    // 自定义 meter 总步数 以及 step 占比
    meter: {
      steps: 50,
      stepRatio: 0.3
    },
    range: {
      ticks: [0, 1],
      color: ['l(0) 0:#F4664A 0.5:#FAAD14 1:#30BF78']
    },
    indicator: {
      pointer: {
        style: {
          stroke: '#D0D0D0'
        }
      },
      pin: {
        style: {
          stroke: '#D0D0D0'
        }
      }
    },
    statistic: {
      title: {
        // formatter: ({ percent }: any) => {
        //   return percent
        // },
        style: ({ percent }: any) => {
          return {
            fontSize: '1vw',
            lineHeight: 1,
            color: percent < ticks[1] ? color[0] : percent < ticks[2] ? color[1] : color[2]
          }
        }
      },
      content: {
        offsetY: 36,
        style: {
          fontSize: '1vw',
          color: '#4B535E'
        }
        // formatter: () => '车速'
      }
    },
    onReady: (plot: any) => {
      graphRef.current = plot
    }
  }
  useEffect(() => {
    if (graphRef.current) {
      let data = 0.7
      const interval = setInterval(() => {
        if (data >= 1.5) {
          clearInterval(interval)
        }

        data += 0.005
        graphRef.current.changeData(data > 1 ? data - 1 : data)
      }, 100)
    }
  }, [graphRef])

  return (
    <>
      <BoxContent {...props}>
        <div id="Gauge">
          <Gauge {...config} />
        </div>
      </BoxContent>
    </>
  )
}

export default React.memo(DemoGauge)
