import type { ColumnsType } from 'antd/es/table';
import { Table, Tag, Tree, Empty } from 'antd';
import React, { useState, useRef, useEffect } from 'react';
import './index.less'

interface DataType {
  time: string;
  model: string;
  name: string;
  desc: string;
  key: string,

}
const { DirectoryTree } = Tree;

const columns: ColumnsType<DataType> = [

  { title: "序号", align: 'center', width: 68, render: (text, record, index) => `${index + 1}`, },
  {
    align: 'center',
    title: '年份',
    key: 'year',
    render: (item: any) => {
      return <div>{item?.year} </div>
    },
  },
  {
    align: 'center',
    title: '名称',
    key: 'name',
    render: (item: any) => {
      return <div>{item?.name} </div>
    },
  },
  {
    title: '车型',
    align: 'center',
    key: 'code',
    render: (item: any) => {
      return <div>{item?.level?.code}/{item?.level?.name}</div>
    },
  },
];
const columns2: ColumnsType<DataType> = [

  { align: 'center', title: "序号", width: 68, render: (text, record, index) => `${index + 1}`, },
  {
    width: 260,
    align: 'center',
    title: '功能类别',
    key: 'category',
    render: (item: any) => {
      // return <div>
      //   <Tag color="#f50">{item?.category?.parent?.parent?.parent?.name}</Tag>
      //   &gt;
      //   <Tag color="#2db7f5">{item?.category?.parent?.parent?.name}</Tag>
      //   &gt;
      //   <Tag color="#87d068">{item?.category?.parent?.name}</Tag>
      // </div>
      return <div >
        <DirectoryTree
          multiple
          defaultExpandAll
          treeData={[
            {
              title: item?.category?.parent?.parent?.parent?.name,
              key: '0-0',
              children: [
                {
                  title: item?.category?.parent?.parent?.name,
                  key: '0-0-0',
                  children: [
                    {
                      title: item?.category?.parent?.name,
                      key: '0-0-1',
                      isLeaf: true
                    },
                  ],
                },
              ],
            },
          ]}
        />
      </div>
    },
  },
  {
    title: '名称',
    align: 'center',
    key: 'name',
    render: (item: any) => {
      return <div>{item?.category?.name}</div>
    },
  },
  {
    title: '描述',
    align: 'center',
    key: 'note',
    className: 'nodeTd scrollbarNone',
    dataIndex: `note`,
    ellipsis: {
      showTitle: false,
    },
    render: (address: any, item: any) => (
      <>
        <span style={{ whiteSpace: 'pre-line' }}>{address}</span>
      </>
    ),
  },
];

const AnalysisList: React.FC = (props: any) => {
  const [tableData, setTableData] = useState<any>([]);
  const [pageSize, setPageSize] = useState<any>(10);


  useEffect(() => {
    if (props.data) {
      let tableData = []
      if (props.type) {
        switch (props.type) {
          case 'LoadRateAnalysis':
            // 搭载率分析
            for (const key in props.data) {
              tableData.push(
                <>
                  <h3>{key.toString()}</h3>
                  <div style={{ display: props.data[key].length > 0 ? 'block' : 'none' }} >
                    <Table rowKey="id" columns={columns} dataSource={props.data[key]} bordered pagination={{
                      pageSize: pageSize,
                      total: props.data[key]?.length,
                      onChange: (page: any, pageSize: any) => setPageSize(pageSize),
                    }} />
                  </div>
                  <Empty style={{ display: props.data[key].length > 0 ? 'none' : "block" }} />
                </>
              )
            }
            break;
          case 'FunctionalLabelAnalysis':
            // 标签分析
            if (!props.data?.list) {
              return false
            }
            console.log(props.data);
            tableData.push(
              <>
                <h3>{props.data?.product_sub_type}</h3>
                <div style={{ display: props.data?.list.length > 0 ? 'block' : 'none' }} >

                  <Table rowKey="id" columns={columns2} dataSource={props.data?.list} bordered scroll={{ y: 480 }} pagination={{
                    pageSize: pageSize,
                    total: props.data?.list.length,
                    onChange: (page: any, pageSize: any) => setPageSize(pageSize),
                  }} />
                </div>
                <Empty style={{ display: props.data?.list.length > 0 ? 'none' : "block" }} />
              </>
            )

            break;
          default:
            break;
        }
      }

      setTableData(tableData)
    }
  }, [props.data, pageSize]);


  return (
    <div id="AnalysisList" style={{ marginBottom: 20, background: '#fff', padding: 20 }}>
      {
        tableData
      }
    </div >
  );
};

export default AnalysisList;