import React, { useEffect, useRef, useState } from 'react';
import { Col, Row, Table } from 'antd';

import {
    ProDescriptionsItemProps,
} from '@ant-design/pro-components';

import { PageIssueData, UserActionData } from '../index.d';
import IssueForm from './IssueForm';


const panelHeaderStyle : React.CSSProperties = {
    backgroundColor: "#3269F0",
    height: '40px',
    paddingBottom: '6px',
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    padding: '6px 16px'
}

interface OperatorLogProps {
    onLogSelected? : (item: UserActionData) => void;
    onSubmitBug? : (item: PageIssueData) => void;
    dataSource  : UserActionData[];
    actionRef?     : React.Ref<UserActionData | undefined>;
}

const OperatorLog = (props: OperatorLogProps) => {

    const columns: ProDescriptionsItemProps<UserActionData>[] = [
        {
            title: '功能页面',
            dataIndex: 'page',
            formItemProps: {
                rules: [
                {
                    required: true,
                    message: '名称为必填项',
                }],
            },
        },
        {
            title: '交互方式',
            dataIndex: 'action',
            valueType: 'text',
            valueEnum: {
                0: { text: '单指单击', status: 'ONE_TOUCH' },
                1: { text: '单指滑动', status: 'ONE_SWAP' },
                2: { text: '单指双击', status: 'ONE_DOUBLETOUCH' },
                3: { text: '双指单击', status: 'TWO_TOUCH' },
            },
        },
        {
            title: '交互组件',
            dataIndex: 'widget',
            hideInForm: true,
        },
        {
            title: '操作',
            dataIndex: 'option',
            valueType: 'option',
            render: (_, record) => (
                <>
                    <IssueForm userAction={record} onBugSubmit={props.onSubmitBug}/>
                </>
            ),
        },
    ];

    return (
        <>
            <div style={panelHeaderStyle}>
                <div>用户操作日志</div>
            </div>
            <Row>
                <Col span={24}>
                    <Table
                        headerTitle="界面交互操作纪录"
                        dataSource={ props.dataSource }
                        columns={columns}
                        onRow={(record: UserActionData) => {
                            return {
                                onClick: () => {
                                    if (props.onLogSelected) {
                                        props.onLogSelected(record);
                                    }
                                }
                            };
                        }
                        }
                    />
                </Col>
            </Row>
        </>
    );
}

export default OperatorLog;