import React, { useEffect, useRef, useState } from 'react';
import { Col, Row, Divider, Table } from 'antd';
import {
    ActionType,
    ProDescriptionsItemProps,
  } from '@ant-design/pro-components';
import { PageIssueData, BugListProps } from '../index.d';

const panelHeaderStyle : React.CSSProperties = {
    backgroundColor: "#3269F0",
    height: '40px',
    paddingBottom: '6px',
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    padding: '6px 16px'
}



const OperatorLog = (props: BugListProps) => {
    const actionRef = useRef<ActionType>();

    const columns: ProDescriptionsItemProps<PageIssueData>[] = [
        {
            title: '功能页面',
            dataIndex: 'page',
            formItemProps: {
                rules: [
                {
                    required: true,
                    message: '名称为必填项',
                }],
            },
        },
        {
            title: '用户操作',
            dataIndex: 'action',
            valueType: 'text',
            valueEnum: {
                0: { text: '单指单击', status: 'ONE_TOUCH' },
                1: { text: '单指滑动', status: 'ONE_SWAP' },
                2: { text: '单指双击', status: 'ONE_DOUBLETOUCH' },
                3: { text: '双指单击', status: 'TWO_TOUCH' },
            },
        },
        {
            title: '交互组件',
            dataIndex: 'widget',
            hideInForm: true,
        },
        {
            title: '错误类型',
            dataIndex: 'issueType',
            valueType: 'text',
            valueEnum: {
                0: { text: '操作无响应', status: 'NO_RESPONSE' },
                1: { text: '响应错误', status: 'RESPONSE_ERROR' },
                2: { text: '显示错误', status: 'DISPLAY_ERROR' },
                3: { text: '样式错误', status: 'STYLE_ERROR' },
            },
        },
        {
            title: '操作',
            dataIndex: 'option',
            valueType: 'option',
            render: (_, record) => (
                <>
                    <a
                        onClick={() => {
                            props.onRemove(record);
                        }}
                    >
                        删除
                    </a>
                </>
            ),
        },
    ];

    return (
        <>
            <div style={panelHeaderStyle}>
                <div>已提交页面BUG列表</div>
            </div>
            <Row>
                <Col span={24}>
                    <Table
                        headerTitle="页面错误信息列表"
                        actionRef={actionRef}
                        dataSource={props.dataSource}
                        columns={columns}
                    />
                </Col>
            </Row>
        </>
    );
}

export default OperatorLog;