import React, { useRef, useState, useCallback, useEffect } from 'react';
import { TinyColor } from '@ctrl/tinycolor';
import { Button, Card, Space, Row, Col } from 'antd';
import { CameraOutlined } from '@ant-design/icons';
import { useLocation, useNavigate } from 'react-router-dom';
import { AudioRecorder } from 'react-audio-voice-recorder';
import './style.css'

let defaultContext = ''

const VoiceCollectionPage = () => {
  const [transcript, setTranscript] = useState('');
  const [recognition, setRecognition] = useState(null);
  const [type, setType] = useState(false);

  useEffect(() => {

  })




  const addAudioElement = (blob: any) => {
    const url = URL.createObjectURL(blob);
    const audio = document.createElement("audio");
    audio.src = url;
    audio.controls = true;
    document.body.appendChild(audio);
  };

  return (
    <>
      <div className="voiceCollection">
        <Card title={false} bordered={false} style={{ width: 800 }}>
          <Row>
            <AudioRecorder
              onRecordingComplete={addAudioElement}
              audioTrackConstraints={{
                noiseSuppression: true,
                echoCancellation: true,
              }}
              downloadOnSavePress={true}
              downloadFileExtension="webm"
            />
          </Row>
        </Card>
      </div>
    </>
  );
};
export default VoiceCollectionPage;
