import React, { useState, useEffect, useRef, Children } from 'react';
import { Card, Col, Row, Avatar, List, Drawer, Modal, Empty, message, Carousel, Space, Table, Progress, Image, Button } from 'antd';
import { AimOutlined, SolutionOutlined } from '@ant-design/icons';
import type { TableProps } from 'antd';
import { CheckCard } from '@ant-design/pro-components';
import { Link, useLocation, useNavigate, useRouteLoaderData, useSearchParams } from 'react-router-dom';

import type { TaskListResponseWithStatics } from '@/api/types';
import { usePageSize } from '@/hooks/usePageSize';
import _ from 'lodash';
import { getFinshTaskList, getFinshTrainList } from '@/api/services/task';
import * as storage from '@/utils/storage';
import './style.css'

import hand from './images/hand.jpg'
import face from './images/face.png'

const { Meta } = Card;


interface DataType {
  key: string;
  value: any;
  title: any;
}



const ClassifyPage = () => {
  const { state } = useLocation();
  const carouselRef = useRef(null) as any;
  const navigate = useNavigate();
  const routerLoaderData = useRouteLoaderData('scoring') as TaskListResponseWithStatics;
  const tasks = _.get(routerLoaderData, 'data');
  const meta_data = _.get(routerLoaderData, 'meta_data');
  const pageSize = usePageSize();
  const role = storage.get('role');
  const username = storage.get('username');
  const [percent, setPercent] = useState<number>(0);
  const [data, setData] = useState<any>([]);
  const [searchParams] = useSearchParams();

  const columns: TableProps<DataType>['columns'] = [
    {
      title: '标点',
      dataIndex: 'order',
      key: 'order',
      width: 300,
    },
    {
      title: '分数(扣分)',
      dataIndex: 'totalScore',
      key: 'totalScore',
      width: 300,
    },
  ];
  useEffect(() => {

    if (state) {
      console.log(state);
      setPercent(state?.score)
      setData(state?.object)
    }
    return () => {

    };

  }, []);



  return (
    <>
      <div className="scoring">
        <Row>
          <Col span={8}>
            <div>
              <Progress
                type="dashboard"
                percent={percent}
                strokeWidth={20}
                format={(percent) => `${percent} 分`}
              />
              <div style={{ marginTop: 20 }}>
                <Space direction="vertical" size="middle" style={{ display: 'flex' }}>
                  <Button type="primary" icon={<AimOutlined />} size={'middle'} onClick={() => { navigate(-1); }}>
                    重新标注
                  </Button>
                  <Button type="primary" icon={<SolutionOutlined />} size={'middle'} onClick={() => { navigate('/classify') }}>
                    返回训练
                  </Button>
                </Space>
              </div>
            </div>
          </Col>
          <Col span={16} >
            <Space>
              <div style={{ width: 300, textAlign: 'center' }} >
                <Image
                  width={260}
                  src={searchParams.get('model') === 'face' ? face : searchParams.get('model') === 'gesture' ? hand : ''}
                />
              </div>
              <div style={{ width: 300, textAlign: 'center' }} >
                <Image
                  width={260}
                  src={searchParams.get('model') === 'face' ? face : searchParams.get('model') === 'gesture' ? hand : ''}
                />
              </div>
            </Space>
            <Table
              style={{ minWidth: 600, marginTop: 20 }}
              bordered
              rowKey="key"
              columns={columns}
              dataSource={data}
              pagination={{
                pageSize: 5,
                onChange: (page) => console.log(page),
              }}
            />
          </Col>
        </Row>
      </div>
    </>
  );
};
export default ClassifyPage;
