import React from 'react';
import { PlusOutlined } from '@ant-design/icons';
import {
  ModalForm,
  ProForm,
  ProFormDateRangePicker,
  ProFormSelect,
  ProFormText,
} from '@ant-design/pro-components';
import { Button, Form, message, SelectProps } from 'antd';
import { IssueFormProps, PageIssueData } from '../index.d';

const waitTime = (time: number = 100) => {
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve(true);
    }, time);
  });
};

const issueTypeOption: SelectProps['options'] = [
    {
        label: '操作无响应',
        value: 'NO_RESPONSE'
    },
    {
        label: '响应错误',
        value: 'RESPONSE_ERROR'
    },
    {
        label: '显示错误',
        value: 'DISPLAY_ERROR'
    },
    {
        label: '样式错误',
        value: 'STYLE_ERROR'
    }
];

const IssueForm = (props:IssueFormProps) => {

    const [form] = Form.useForm<PageIssueData>();

    return (
        <ModalForm<PageIssueData>
            title="页面BUG提交"
            trigger={
              <Button type="primary" size='small'>
                <PlusOutlined />
                提交BUG
              </Button>
            }
            form={form}
            autoFocusFirstInput
            modalProps={{
              destroyOnClose: true,
              onCancel: () => console.log('run'),
            }}
            submitTimeout={2000}
            onFinish={async (values) => {
              await waitTime(1000);
              props.onBugSubmit(values);
              message.success('提交成功');
              return true;
            }}
          >
            <ProFormText
                width="md"
                name="page"
                label="交互页面"
                tooltip="操作页面"
                initialValue={props.userAction.page}
                readonly
            />
      
            <ProFormText
                width="md"
                name="widget"
                label="页面组件"
                initialValue={props.userAction.widget}
                readonly
            />
            
            <ProFormText
                width="md"
                name="action"
                label="用户操作"
                initialValue={props.userAction.action}
                readonly
            />
            
            <ProFormSelect name="issueType" label="错误类型" options={issueTypeOption}/>

          </ModalForm>
    );
}
export default IssueForm;
