#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2021/7/21 16:45
# @Author : Opfer
# @Site :
# @File : realtime_dispatch.py
# @Software: PyCharm


# 实时调度模块

from traffic_flow.traffic_flow_planner import *
from para_config import *
from equipment.truck import TruckInfo
from equipment.excavator import ExcavatorInfo
from equipment.dump import DumpInfo
import sched
import time
from group_control.group_control import Group

dump = DumpInfo()
excavator = ExcavatorInfo()
truck = TruckInfo(dump, excavator)


# 调度类
class Dispatcher(WalkManage):
    def __init__(self):

        # 模拟挖机/卸载设备产量(防止调度修改真实产量)
        self.sim_dump_real_mass = np.zeros(dump.get_dump_num())
        self.sim_excavator_real_mass = np.zeros(excavator.get_excavator_num())
        # 真实设备可用时间
        self.cur_truck_reach_dump = np.zeros(truck.get_truck_num())
        self.cur_truck_reach_excavator = np.zeros(truck.get_truck_num())
        self.cur_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.cur_dump_ava_time = np.zeros(dump.get_dump_num())
        # 卡车完成装载及卸载时间(矿卡可用时间)
        self.cur_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟矿卡可用时间
        self.sim_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟各设备可用时间(防止调度修改真实产量)
        self.sim_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.sim_dump_ava_time = np.zeros(dump.get_dump_num())
        # 挖机/卸载设备预计产量(包含正在驶往挖机/卸载设备那部分矿卡的载重)
        self.pre_dump_real_mass = np.zeros(dump.get_dump_num())
        self.pre_excavator_real_mass = np.zeros(excavator.get_excavator_num())

        # 维护一个矿卡调度表
        self.Seq = [[] for _ in range(truck.get_truck_num())]
        # 调度开始时间
        self.start_time = datetime.now()
        # self.relative_now_time = datetime.now() - self.start_time

        self.path = PathPlanner()

        # 读取车流信息

        self.traffic_flow = Traffic_flow(dump, excavator, truck)

        self.group = Group(dump, excavator, truck, self.traffic_flow)


    # 更新矿卡预计抵达目的地时间
    def update_truck_reach_time(self):
        try:
            dynamic_excavator_num = excavator.get_excavator_num()
            dumps = dump.get_dump_num()
            trucks = truck.get_truck_num()

            truck_current_task = truck.get_truck_current_task()

            truck_current_trip = truck.get_truck_current_trip()

            cur_truck_reach_excavator = truck.get_truck_reach_excavator()

            cur_truck_reach_dump = truck.get_truck_reach_dump()

            excavator_ava_ls = [[] for _ in range(dynamic_excavator_num)]
            dump_ava_ls = [[] for _ in range(dumps)]
            for i in range(trucks):
                task = truck_current_task[truck.truck_index_to_uuid_dict[i]]
                end_area_index = truck_current_trip[i][1]
                if task in [0, 1]:
                    reach_time = cur_truck_reach_excavator[i]
                    excavator_ava_ls[end_area_index].append(
                        [reach_time, i, end_area_index]
                    )
                elif task in [3, 4]:
                    reach_time = cur_truck_reach_dump[i]
                    dump_ava_ls[end_area_index].append([reach_time, i, end_area_index])
                elif task == -2:
                    self.cur_truck_ava_time[i] = (
                        datetime.now() - self.start_time
                    ) / timedelta(hours=0, minutes=1, seconds=0)

            # print(truck_index_to_uuid_dict)
            # print(excavator_ava_ls)
            # print(dump_ava_ls)
        except Exception as es:
            logger.error("矿卡预计抵达时间计算异常")
            logger.error(es)

        return excavator_ava_ls, dump_ava_ls

    # 更新挖机预计可用时间
    def update_excavator_ava_time(self, excavator_ava_ls):

        # 初始化挖机可用时间
        self.cur_excavator_ava_time = np.full(
            get_value("dynamic_excavator_num"),
            (datetime.now() - self.start_time)
            / timedelta(hours=0, minutes=1, seconds=0),
        )

        loading_time = excavator.get_loading_time()

        loading_task_time = excavator.get_loading_task_time()

        try:

            now = float(
                (datetime.now() - self.start_time)
                / timedelta(hours=0, minutes=1, seconds=0)
            )

            for reach_ls in excavator_ava_ls:
                if len(reach_ls) != 0:
                    reach_ls = np.array(reach_ls)
                    tmp = reach_ls[np.lexsort(reach_ls[:, ::-1].T)]
                    for i in range(len(tmp)):
                        excavator_index = int(tmp[i][2])
                        self.cur_excavator_ava_time[excavator_index] = (
                            max(tmp[i][0], self.cur_excavator_ava_time[excavator_index])
                            + loading_task_time[excavator_index]
                        )
                        self.cur_truck_ava_time[
                            int(tmp[i][1])
                       ] = self.cur_excavator_ava_time[excavator_index]

                        # # 若挖机可用时间严重偏离，进行修正
                        # if abs(self.cur_excavator_ava_time[excavator_index] - now) > 60:
                        #     self.cur_truck_ava_time[int(tmp[i][1])] = now
                        # if abs(self.cur_excavator_ava_time[excavator_index] - now) > 60:
                        #     self.cur_excavator_ava_time[excavator_index] = now
        except Exception as es:
            logger.error("挖机可用时间计算异常")
            logger.error(es)

    # 更新卸载设备预计可用时间
    def update_dump_ava_time(self, dump_ava_ls):

        dynamic_dump_num = dump.get_dump_num()

        # 初始化卸载设备可用时间
        self.cur_dump_ava_time = np.full(
            dynamic_dump_num,
            (datetime.now() - self.start_time)
            / timedelta(hours=0, minutes=1, seconds=0),
        )

        unloading_time = dump.get_unloading_time()

        unloading_task_time = dump.get_unloading_task_time()

        try:

            now = float(
                (datetime.now() - self.start_time)
                / timedelta(hours=0, minutes=1, seconds=0)
            )

            for reach_ls in dump_ava_ls:
                if len(reach_ls) != 0:
                    reach_ls = np.array(reach_ls)
                    tmp = reach_ls[np.lexsort(reach_ls[:, ::-1].T)]
                    for i in range(len(tmp)):
                        dump_index = int(tmp[i][2])
                        self.cur_dump_ava_time[dump_index] = (
                            max(tmp[i][0], self.cur_dump_ava_time[dump_index])
                            + unloading_task_time[dump_index]
                        )
                        self.cur_truck_ava_time[
                            int(tmp[i][1])
                        ] = self.cur_dump_ava_time[dump_index]

                        # # 若卸载设备可用时间严重偏离，进行修正
                        # if abs(self.cur_dump_ava_time[dump_index] - now) > 60:
                        #     self.cur_dump_ava_time[dump_index] = now
                        # if abs(self.cur_truck_ava_time[int(tmp[i][1])] - now) > 60:
                        #     self.cur_truck_ava_time[int(tmp[i][1])] = now
        except Exception as es:
            logger.error("卸载设备可用时间计算异常")
            logger.error(es)

    def dispatcher_period_update(self):

        # 装载映射参数及
        self.period_map_para_load()

        self.period_walk_para_load()

        # 更新卸载设备对象
        dump.para_period_update()

        # 更新挖机对象
        excavator.para_period_update()

        # 更新矿卡对象
        truck.para_period_update(dump, excavator)

        truck.state_period_update()

        # 更新实时车流
        # self.update_actual_traffic_flow()
        self.traffic_flow.update_actual_traffic_flow()

        # 矿卡抵达时间
        excavator_reach_list, dump_reach_list = self.update_truck_reach_time()

        # 挖机可用时间
        self.update_excavator_ava_time(excavator_reach_list)

        # 卸载设备可用时间
        self.update_dump_ava_time(dump_reach_list)

        self.cost_to_excavator, self.cost_to_dump, self.cost_park_to_excavator = self.path.walk_cost()

        # 调度分组更新
        self.group.period_update()

    def sim_para_reset(self):

        # 设备可用时间重置
        self.sim_truck_ava_time = copy.deepcopy(self.cur_truck_ava_time)
        self.sim_excavator_ava_time = copy.deepcopy(self.cur_excavator_ava_time)
        self.sim_dump_ava_time = copy.deepcopy(self.cur_dump_ava_time)

    def reset(self):
        # 模拟挖机/卸载设备产量(防止调度修改真实产量)
        self.sim_dump_real_mass = np.zeros(dump.get_dump_num())
        self.sim_excavator_real_mass = np.zeros(excavator.get_excavator_num())
        # 真实设备可用时间
        self.cur_truck_reach_dump = np.zeros(truck.get_truck_num())
        self.cur_truck_reach_excavator = np.zeros(truck.get_truck_num())
        self.cur_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.cur_dump_ava_time = np.zeros(dump.get_dump_num())
        # 卡车完成装载及卸载时间(矿卡可用时间)
        self.cur_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟矿卡可用时间
        self.sim_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟各设备可用时间(防止调度修改真实产量)
        self.sim_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.sim_dump_ava_time = np.zeros(dump.get_dump_num())
        # 挖机/卸载设备预计产量(包含正在驶往挖机/卸载设备那部分矿卡的载重)
        self.pre_dump_real_mass = np.zeros(dump.get_dump_num())
        self.pre_excavator_real_mass = np.zeros(excavator.get_excavator_num())

        # 维护一个矿卡调度表
        self.Seq = [[] for _ in range(truck.get_truck_num())]

    def truck_schedule(self, truck_id):

            # 规则读取
            global transport_value
            rule3 = session_mysql.query(DispatchRule).filter_by(id=3).first().disabled

            rule4 = session_mysql.query(DispatchRule).filter_by(id=4).first().disabled

            # 读取优先级设置
            excavator_priority_coefficient = excavator.excavator_priority_coefficient

            excavator_material_priority = excavator.excavator_material_priority

            # 矿卡对应序号
            truck_index = truck.truck_uuid_to_index_dict[truck_id]

            # 矿卡行程
            trip = truck.get_truck_current_trip()[truck_index]

            # 矿卡当前任务
            task = truck.get_truck_current_task()[truck.truck_index_to_uuid_dict[truck_index]]

            if truck_id not in self.group.dispatch_truck_group:
                logger.error("无该矿卡")
                return -1

            # 矿卡调度分组
            group_id = self.group.dispatch_truck_group[truck_id]

            dynamic_dump_num = dump.get_dump_num()

            dynamic_excavator_num = excavator.get_excavator_num()

            target = 0

            # 是否启用挖机均衡
            rule_ex = True

            # 车流计算
            # 驶往卸载设备的实际车流
            actual_goto_dump_traffic_flow = self.traffic_flow.actual_goto_dump_traffic_flow

            # 驶往挖机的实际车流
            actual_goto_excavator_traffic_flow = self.traffic_flow.actual_goto_excavator_traffic_flow

            # 计算理想车流
            opt_goto_dump_traffic_flow, opt_goto_excavator_traffic_flow = traffic_flow_plan(truck)

            logger.info("==========================================================")
            logger.info(f"调度矿卡 {truck_id} {truck_index} {truck_uuid_to_name_dict[truck_id]}")

            if task == -2:
                try:
                    logger.info("矿卡状态：矿卡启动或故障恢复")
                    logger.info("矿卡行程：无")
                    logger.info(f"涉及挖机：{list(excavator.excavator_uuid_to_index_dict.keys())}")
                    logger.info("物料类型")
                    if truck_id in truck.truck_material_bind:
                        logger.info(truck.truck_material_bind[truck_id])
                    logger.info("挖机物料优先级")
                    logger.info(excavator_material_priority)
                    logger.info("挖机设备优先级")
                    logger.info(excavator_priority_coefficient)

                    logger.info("分组车流")
                    logger.info(self.group.group_actual_goto_dump_traffic_flow[group_id])
                    logger.info(self.group.group_opt_goto_dump_traffic_flow[group_id])

                except Exception as es:
                    logger.error(f"矿卡{truck_id}状态不匹配")
                    logger.error(es)

                try:
                    # 1. 矿卡是否存在绑定挖机
                    if truck_id in truck.truck_excavator_bind:
                        target = excavator.excavator_uuid_to_index_dict[truck.truck_excavator_bind[truck_id]]
                    # 2. 正常调度
                    elif not rule_ex:

                        transport_value = self.group.group_park_to_excavator[group_id]

                        excavator_exclude_modify = self.group.group_excavator_exclude_modify[truck_id]
                        # excavator_material_bind_modify = self.group.group_excavator_material_bind_modify[truck_id]

                        logger.info("transport_value")
                        logger.info(transport_value)
                        target = np.argmin(
                            transport_value
                            + excavator_exclude_modify)
                            # + excavator_material_bind_modify)
                        target = excavator.excavator_uuid_to_index_dict[self.group.group_excavator_index_to_uuid_dict[group_id][target]]
                    # 3. 启用饱和度调度
                    else:
                        logger.info("饱和度调度")
                        logger.info(truck.excavator_hold_truck_num)
                        logger.info(np.mean(truck.payload))
                        logger.info(self.group.update_excavator_hold_truck(truck.excavator_hold_truck_num))

                        excavator_hold_truck = self.group.update_excavator_hold_truck(truck.excavator_hold_truck_num)[group_id]

                        actual_flow_to_excavator = excavator_hold_truck * np.mean(truck.payload) / self.group.group_park_to_excavator[group_id].reshape(1, -1).flatten()

                        # allow_flow_to_excavator = excavator.excavator_strength

                        allow_flow_to_excavator = self.group.update_allow_flow_to_excavator()[group_id]

                        target = np.argmin(actual_flow_to_excavator / allow_flow_to_excavator)

                        target = excavator.excavator_uuid_to_index_dict[self.group.group_excavator_index_to_uuid_dict[group_id][target]]

                    logger.info(excavator.excavator_uuid_to_index_dict)
                    logger.info(self.group.group_excavator_uuid_to_index_dict)
                    logger.info(f"目的地：{excavator.excavator_index_to_uuid_dict[target]}")
                except Exception as es:
                    logger.error("error07")
                    logger.error(es)
            if task in [0, 1, 2]:
                try:
                    logger.info("矿卡状态：矿卡空载")
                    logger.info(f"涉及卸载设备：{list(dump.dump_uuid_to_index_dict.keys())}")
                except Exception as es:
                    logger.error(f"矿卡{truck_id}状态不匹配")
                    logger.error(es)

                try:
                    assert np.array(actual_goto_dump_traffic_flow).shape == (
                        dynamic_excavator_num,
                        dynamic_dump_num,)
                    assert np.array(opt_goto_dump_traffic_flow).shape == (
                        dynamic_excavator_num,
                        dynamic_dump_num,)
                except Exception as es:
                    logger.warning(es)
                    actual_goto_dump_traffic_flow = np.array(
                        actual_goto_dump_traffic_flow).reshape((dynamic_excavator_num, dynamic_dump_num))
                    opt_goto_dump_traffic_flow = np.array(
                        opt_goto_dump_traffic_flow).reshape((dynamic_excavator_num, dynamic_dump_num))

                actual_goto_dump_traffic_flow = np.array(actual_goto_dump_traffic_flow)
                opt_goto_dump_traffic_flow = np.array(opt_goto_dump_traffic_flow)

                # 日志记录部分
                try:
                    logger.info("挖机id:")
                    logger.info(excavator.excavator_uuid_to_index_dict)
                    logger.info("卸点id:")
                    logger.info(dump.dump_uuid_to_index_dict)
                    logger.info(f"卸载点实际车流:")
                    logger.info(actual_goto_dump_traffic_flow)
                    logger.info(f"卸载点理想车流:")
                    logger.info(opt_goto_dump_traffic_flow)

                    logger.info("卸载点实际车流")
                    logger.info(actual_goto_dump_traffic_flow[int(trip[1]), :])
                    logger.info("卸载点理想车流")
                    logger.info(opt_goto_dump_traffic_flow[int(trip[1]), :])
                    logger.info("空载trip")
                    logger.info(trip)
                    logger.info("物料类型")
                    if truck_id in truck.truck_material_bind:
                        logger.info(truck.truck_material_bind[truck_id])
                    logger.info("驶往卸点的运输成本")
                    logger.info(self.cost_to_dump)
                    logger.info("卸点物料修正")
                    logger.info(truck.dump_material_bind_modify)

                except Exception as es:
                    logger.info("车流及修正因子")
                    logger.info(es)

                # 1. 绑定调度
                if truck_id in truck.truck_dump_bind:
                    bind_unload_area_id = truck.truck_dump_bind[truck_id]
                    for key, value in dump.dump_index_to_unload_area_index_dict.items():
                        if value == unload_area_uuid_to_index_dict[bind_unload_area_id]:
                            target = key
                            break
                # 2. 正常调度
                elif not rule_ex:
                    try:
                        excavator_index = int(trip[1])
                        excavator_id = excavator.excavator_index_to_uuid_dict[excavator_index]

                        print(self.group.group_excavator_uuid_to_index_dict[group_id])

                        group_excavator_index = self.group.group_excavator_uuid_to_index_dict[group_id][excavator_id]
                        # 2.1 正常调度
                        if rule3 and rule4:
                            try:
                                # ga changed
                            # transport_value = self.cost_to_dump[:, int(trip[1])]
                            #     transport_value = self.group.group_walk_to_dump_cost[group_excavator_index]
                                transport_value = self.group.group_walk_to_dump_cost[group_id][:, excavator_index]
                            except Exception as es:
                                logger.error("error10")
                                logger.error(es)
                                logger.error("group_id")
                                logger.error(group_id)
                                logger.error('self.group.group_walk_to_dump_cost')
                                logger.error(self.group.group_walk_to_dump_cost)
                                logger.error('self.group.group_walk_to_excavator_cost')
                                logger.error(self.group.group_walk_to_excavator_cost)
                                logger.error('self.group.group_excavator_uuid_to_index_dict[group_id][excavator_id]')
                                logger.error(self.group.group_excavator_uuid_to_index_dict[group_id][excavator_id])
                                logger.error("self.group.group_excavator_uuid_to_index_dict[group_id]")
                                logger.error(self.group.group_excavator_uuid_to_index_dict[group_id])
                        # 2.2 车流规划
                        else:
                            try:

                                # 计算 group actual traffic flow
                                group_actual_goto_dump_traffic_flow = self.group.group_actual_goto_dump_traffic_flow[group_id]

                                # 计算 group actual traffic flow
                                group_opt_goto_dump_traffic_flow = self.group.group_opt_goto_dump_traffic_flow[group_id]

                                logger.info("驶往卸点分组车流")
                                logger.info(group_actual_goto_dump_traffic_flow)
                                logger.info(group_opt_goto_dump_traffic_flow)

                                try:
                                    transport_value = (group_actual_goto_dump_traffic_flow[group_excavator_index, :] + 0.001) \
                                                    / (group_opt_goto_dump_traffic_flow[group_excavator_index, :] + 0.001)
                                except Exception as es:
                                    logger.error("error09")
                                    logger.error(es)

                            except Exception as es:
                                logger.error("error11")
                                logger.error(es)
                            logger.info("transport_value")
                            logger.info(transport_value)
                            logger.info("dump_material_bind_modify")
                            logger.info(truck.dump_material_bind_modify[truck_index])

                        try:
                            dump_material_bind_modify = self.group.group_dump_material_bind_modify[truck_id]
                        except Exception as es:
                            logger.error("error13")
                            logger.error(es)
                            logger.error("self.group.group_dump_material_bind_modify")
                            logger.error(self.group.group_dump_material_bind_modify)

                        try:
                            target = np.argmin(transport_value.T + dump_material_bind_modify)
                            target = dump.dump_uuid_to_index_dict[self.group.group_dump_index_to_uuid_dict[group_id][target]]
                            logger.info("target")
                            logger.info(target)
                        except Exception as es:
                            logger.error("error12")
                            logger.error(es)
                            logger.error("target")
                            logger.error(target)
                            logger.error("transport_value")
                            logger.error(transport_value)
                            logger.error(type(transport_value))
                            logger.error(transport_value.T)
                            logger.error("dump_material_bind_modify")
                            logger.error(dump_material_bind_modify)

                            logger.error("self.group.group_dump_index_to_uuid_dict")
                            logger.error(self.group.group_dump_index_to_uuid_dict)
                            logger.error("self.group.group_dump_index_to_uuid_dict[group_id]")
                            logger.error(self.group.group_dump_index_to_uuid_dict[group_id])

                        try:
                            logger.info("车流比:")
                            logger.info((actual_goto_dump_traffic_flow[int(trip[1]), :] + 0.001) \
                                        / (opt_goto_dump_traffic_flow[int(trip[1]), :] + 0.001))
                        except Exception as es:
                            logger.error("error08")
                            logger.error(es)

                    except Exception as es:
                        logger.error("error06")
                        logger.error(es)
                # 3. 饱和度调度
                else:

                    logger.info("和度调度")

                    excavator_index = int(trip[1])

                    transport_value = self.group.group_walk_to_dump_cost[group_id][:, excavator_index].reshape(1, -1)

                    dump_hold_truck = self.group.update_dump_hold_truck(truck.dump_hold_truck_num)[group_id]

                    actual_flow_to_dump = dump_hold_truck * truck.payload / \
                                          self.group.group_walk_to_dump_cost[group_id][:, excavator_index].reshape(1,
                                                                                                                   -1)
                    allow_flow_to_dump = dump.dump_strength

                    allow_flow_to_dump = self.group.update_allow_flow_to_dump()[group_id]

                    target = np.argmax((1 - actual_flow_to_dump / allow_flow_to_dump) / transport_value)

                    target = dump.dump_uuid_to_index_dict[
                        self.group.group_dump_index_to_uuid_dict[group_id][target]]

                logger.info(f"目的地：{dump.dump_index_to_uuid_dict[target]}")

            elif task in [3, 4, 5]:

                try:
                    logger.info("矿卡状态：矿卡重载")
                    logger.info(f"涉及挖机设备：{list(excavator.excavator_uuid_to_index_dict.keys())}")
                except Exception as es:
                    logger.error(f"矿卡{truck_id}状态不匹配")
                    logger.error(es)

                # 读取车流信息
                try:
                    assert np.array(actual_goto_excavator_traffic_flow).shape == (
                        dynamic_dump_num,
                        dynamic_excavator_num,)
                    assert np.array(opt_goto_excavator_traffic_flow).shape == (
                        dynamic_dump_num,
                        dynamic_excavator_num,)

                except Exception as es:
                    logger.warning(es)
                    actual_goto_excavator_traffic_flow = np.array(
                        actual_goto_excavator_traffic_flow).reshape((dynamic_dump_num, dynamic_excavator_num))
                    opt_goto_excavator_traffic_flow = np.array(
                        opt_goto_excavator_traffic_flow).reshape((dynamic_dump_num, dynamic_excavator_num))


                # 不知道为什么，偶尔变成了list
                actual_goto_excavator_traffic_flow = np.array(actual_goto_excavator_traffic_flow)
                opt_goto_excavator_traffic_flow = np.array(opt_goto_excavator_traffic_flow)

                try:
                    logger.info("挖机id:")
                    logger.info(excavator.excavator_uuid_to_index_dict)
                    logger.info("卸点id:")
                    logger.info(dump.dump_uuid_to_index_dict)
                    logger.info(f"挖机实际车流:")
                    logger.info(actual_goto_excavator_traffic_flow)
                    logger.info(f"挖机理想车流:")
                    logger.info(opt_goto_excavator_traffic_flow)
                    logger.info("重载trip")
                    logger.info(trip)
                    logger.info("物料类型")
                    if truck_id in truck.truck_material_bind:
                        logger.info(truck.truck_material_bind[truck_id])
                    logger.info("驶往挖机的运输成本")
                    logger.info(self.cost_to_excavator)
                    logger.info("挖机物料修正")
                    logger.info(truck.excavator_material_bind_modify)
                    logger.info("挖机优先级修正")
                    logger.info(excavator.excavator_priority_coefficient)
                except Exception as es:
                    logger.info("车流及修正因子")
                    logger.info(es)

                # 计算目的地
                try:
                    # 1. 绑定调度
                    if truck_id in truck.truck_excavator_bind:
                        target = excavator.excavator_uuid_to_index_dict[truck.truck_excavator_bind[truck_id]]
                        logger.info("矿卡已绑定挖机")
                    # 2. 正常调度
                    elif not rule_ex:
                        logger.info("cost_to_excavator")
                        logger.info(self.cost_to_excavator)

                        dump_index = int(trip[1])
                        dump_id = dump.dump_uuid_to_index_dict[dump_index]
                        # 2.1 正常调度
                        if rule3 and rule4:
                            # transport_value = self.cost_to_excavator[int(trip[1]), :]
                            transport_value = self.group.group_walk_to_excavator_cost[group_id][dump_index, :]
                        # 2.2 车流规划
                        else:

                            group_dump_index = self.group.group_dump_uuid_to_index_dict[group_id][dump_id]

                            # 提取group actual traffic flow
                            group_actual_goto_excavator_traffic_flow = self.group.group_actual_goto_excavator_traffic_flow[
                                group_id]

                            # 提取group actual traffic flow
                            group_opt_goto_excavator_traffic_flow = self.group.group_opt_goto_excavator_traffic_flow[
                                group_id]

                            logger.info("驶往挖机分组车流")
                            logger.info(group_actual_goto_excavator_traffic_flow)
                            logger.info(group_opt_goto_excavator_traffic_flow)

                            transport_value = (group_actual_goto_excavator_traffic_flow[group_dump_index, :] + 0.001) \
                                              / (group_opt_goto_excavator_traffic_flow[group_dump_index, :] + 0.001)


                            # transport_value = (self.actual_goto_excavator_traffic_flow[trip[1], :] + 0.001) \
                            #                     / (self.opt_goto_excavator_traffic_flow[trip[1], :] + 0.001)
                            logger.info("transport_value")
                            logger.info(transport_value)

                        # target = np.argmin(transport_value
                        #     + truck.excavator_exclude_modify[truck_index]
                        #     + truck.excavator_material_bind_modify[truck_index])

                        excavator_exclude_modify = self.group.group_excavator_exclude_modify[truck_id]
                        excavator_material_bind_modify = self.group.group_excavator_material_bind_modify[truck_id]

                        logger.info(transport_value)
                        target = np.argmin(
                            transport_value.T
                            + excavator_exclude_modify)
                            # + excavator_material_bind_modify)

                        target = excavator.excavator_uuid_to_index_dict[self.group.group_excavator_index_to_uuid_dict[group_id][target]]

                    # 3. 饱和度调度
                    else:

                        logger.info("和度调度")

                        dump_index = int(trip[1])

                        transport_value = self.group.group_walk_to_excavator_cost[group_id][dump_index, :].reshape(1, -1)

                        excavator_hold_truck = self.group.update_excavator_hold_truck(truck.excavator_hold_truck_num)[
                            group_id]

                        actual_flow_to_excavator = excavator_hold_truck * truck.payload / \
                                                   self.group.group_walk_to_excavator_cost[group_id][dump_index, :].reshape(
                                                       1, -1)

                        # allow_flow_to_excavator = excavator.excavator_strength

                        allow_flow_to_excavator = self.group.update_allow_flow_to_excavator()[group_id]

                        target = np.argmax((1 - actual_flow_to_excavator / allow_flow_to_excavator) / transport_value)

                        target = excavator.excavator_uuid_to_index_dict[
                            self.group.group_excavator_index_to_uuid_dict[group_id][target]]
                except Exception as es:
                   logger.info("trip出错1")
                   logger.info(es)


                try:
                   logger.info("车流比:")
                   logger.info(
                    (actual_goto_excavator_traffic_flow[trip[1], :] + 0.001)
                    / (opt_goto_excavator_traffic_flow[trip[1], :] + 0.001))
                except Exception as es:
                    logger.info("trip出错2")
                    logger.info(es)

                logger.info(f"目的地：{excavator.excavator_index_to_uuid_dict[target]}")

            logger.info("==========================================================")

            print(target)
        # except Exception as es:
        #     logger.error("truck_schedule,error")
        #     logger.error(es)
            return target

    def schedule_construct(self):

        global truck
        global excavator
        global dump

        self.reset()

        print("self.cur_truck_ava_time", self.cur_truck_ava_time)

        try:

            # 读取所需信息
            dynamic_truck_num = get_value("dynamic_truck_num")
            truck_current_trip = truck.get_truck_current_trip()
            truck_current_task = truck.get_truck_current_task()
            payload = truck.get_payload()
            unloading_time = dump.get_unloading_time()
            loading_time = excavator.get_loading_time()

            # 出入场时间
            loading_task_time = excavator.get_loading_task_time()
            unloading_task_time = dump.get_unloading_task_time()

            walk_time_to_unload_area = walk_manage.get_walk_time_to_unload_area()
            walk_time_to_load_area = walk_manage.get_walk_time_to_load_area()

            # Seq初始化
            Seq = [[truck_current_trip[i][1], -1] for i in range(dynamic_truck_num)]

            # 根据矿卡最早可用时间顺序进行规划
            print(self.cur_truck_ava_time)
            print(truck.truck_priority)
            temp = copy.deepcopy(self.cur_truck_ava_time) - truck.truck_priority

            try:
                # 没有启动的矿卡加上一个很大的值，降低其优先级
                for i in range(dynamic_truck_num):
                    task = truck_current_task[truck.truck_index_to_uuid_dict[i]]
                    if task == -2:
                        temp[i] = temp[i] + M
            except Exception as es:
                logger.error("矿卡排序启动异常")
                logger.error(es)

            index = np.argsort(temp.reshape(1, -1))
            index = index.flatten()

            # 对于在线矿卡已经赋予新的派车计划，更新其最早可用时间，及相关设备时间参数
            for truck_index in index:
                if len(Seq[truck_index]) > 0:

                    # try:
                # 获取矿卡id
                    try:
                        truck_id = truck.truck_index_to_uuid_dict[truck_index]
                    except Exception as es:
                        logger.error('error01')
                        logger.error(es)

                    # 判断矿卡是否禁用
                    if truck_id in truck.update_truck_disable_list():
                        continue
                    try:
                    # 获取矿卡当前任务
                        task = truck_current_task[truck.truck_index_to_uuid_dict[truck_index]]
                    except Exception as es:
                        logger.error('error02')
                        logger.error(es)

                    try:
                    # 矿卡结束当前派车计划后的目的地
                        end_eq_index = truck_current_trip[truck_index][1]
                    except Exception as es:
                        logger.error('error03')
                        logger.error(es)

                    try:
                    # 调用调度函数，得到最优目的地序号
                        target_eq_index = self.truck_schedule(truck.truck_index_to_uuid_dict[truck_index])

                    except Exception as es:
                        logger.error('error04')
                        logger.error(es)
                        logger.error("truck_index,uuid")
                        logger.error(truck_index)
                        logger.error(truck.truck_index_to_uuid_dict[truck_index])

                    # logger.("target_eq_index")
                    # logger.error(target_eq_index)
                    try:
                    # 写入Seq序列
                        Seq[truck_index][1] = target_eq_index
                    except Exception as es:
                        logger.error('error05')
                        logger.error(es)
                        logger.error("target_eq_index")
                        logger.error(target_eq_index)
                        logger.error("target_eq_index,type")
                        logger.error(type(target_eq_index))
                    # except Exception as es:
                    #     logger.error("truck,task,end_eq_index,error")
                    #     logger.error(es)
                    try:
                        group_id = self.group.dispatch_truck_group[truck_id]
                    except Exception as es:
                        logger.error("非动态调度矿卡")
                        logger.error(es)

                    # except Exception as es:
                    #     # logger.error(f'矿卡 {truck_uuid_to_name_dict[self.truck_index_to_uuid_dict[truck_index]]} 派车计划计算异常')
                    #     logger.error(f'矿卡派车计划计算异常')
                    #     logger.error(es)

                    try:

                        if task in empty_task_set:
                            target_area_index = dump.dump_index_to_unload_area_index_dict[target_eq_index]
                            end_area_index = excavator.excavator_index_to_load_area_index_dict[end_eq_index]
                            # 更新变量，预计产量更新
                            self.sim_dump_real_mass[target_eq_index] = \
                                (self.sim_dump_real_mass[target_eq_index] + payload[truck_index])
                            # 预计卸载设备可用时间更新
                            self.sim_dump_ava_time[target_eq_index] = (
                                max(
                                    self.sim_dump_ava_time[target_eq_index],
                                    self.sim_truck_ava_time[truck_index] + \
                                    walk_time_to_unload_area[target_area_index][end_area_index],)
                                + unloading_task_time[target_eq_index]
                            )
                        elif task in heavy_task_set:
                            target_area_index = (excavator.excavator_index_to_load_area_index_dict[target_eq_index])
                            end_area_index = dump.dump_index_to_unload_area_index_dict[end_eq_index]
                        else:
                            pass
                    except Exception as es:
                        logger.error( f"矿卡 {truck_uuid_to_name_dict[truck.truck_index_to_uuid_dict[truck_index]]} 调度状态更新异常")
                        logger.error(es)

            for i in range(len(Seq)):
                try:
                    try:
                        truck_id = truck.truck_index_to_uuid_dict[i]
                        group_id = self.group.dispatch_truck_group[truck_id]

                        record = {"truckId": truck.truck_index_to_uuid_dict[i]}
                        task = truck.get_truck_current_task()[truck.truck_index_to_uuid_dict[i]]
                    except Exception as es:
                        logger.error("truck_id,group_id,record,task出错")
                        logger.error(es)

                    if task in empty_task_set:
                        item = (
                            session_mysql.query(Dispatch)
                            .filter_by(dump_id=dump.dump_index_to_uuid_dict[Seq[i][1]],
                                       exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][0]],
                                       truck_id=truck_id,
                                       group_id=group_id,
                                       isauto=1, isdeleted=0,).first())
                        record["exactorId"] = item.exactor_id
                        record["dumpId"] = item.dump_id
                        record["loadAreaId"] = item.load_area_id
                        record["unloadAreaId"] = item.unload_area_id
                        record["dispatchId"] = item.id
                        record["isdeleted"] = False
                        record["creator"] = item.creator
                        record["createtime"] = item.createtime.strftime(
                            "%b %d, %Y %I:%M:%S %p")
                    elif task in heavy_task_set:
                        item = (
                            session_mysql.query(Dispatch)
                            .filter_by(exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][1]],
                                       dump_id=dump.dump_index_to_uuid_dict[Seq[i][0]],
                                       truck_id=truck_id,
                                       group_id=group_id,
                                       isauto=1, isdeleted=0,).first())
                        record["exactorId"] = excavator.excavator_index_to_uuid_dict[Seq[i][1]]
                        record["dumpId"] = item.dump_id
                        record["loadAreaId"] = item.load_area_id
                        record["unloadAreaId"] = item.unload_area_id
                        record["dispatchId"] = item.id
                        record["isdeleted"] = False
                        record["creator"] = item.creator
                        record["createtime"] = item.createtime.strftime(
                            "%b %d, %Y %I:%M:%S %p")
                    elif task == -2:
                        try:
                            try:
                                item = (
                                    session_mysql.query(Dispatch)
                                        .filter_by(exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][1]],
                                                   # truck_id=truck_id,
                                                   group_id=group_id,
                                                   isauto=1, isdeleted=0, ).first())
                            except Exception as es:
                                logger.error("task-2,error01")
                                logger.error(es)
                                logger.error('excavator.excavator_index_to_uuid_dict[Seq[i][1]]')
                                logger.error(excavator.excavator_index_to_uuid_dict)
                                logger.error("seq[i]")
                                logger.error(Seq[i])
                                logger.error("group_id")
                                logger.error(group_id)

                            try:
                                record["exactorId"] = item.exactor_id
                                record["dumpId"] = item.dump_id
                                record["loadAreaId"] = item.load_area_id
                                record["unloadAreaId"] = item.unload_area_id
                                record["dispatchId"] = item.id
                                record["isdeleted"] = False
                                record["creator"] = item.creator
                                record["createtime"] = item.createtime.strftime(
                                    "%b %d, %Y %I:%M:%S %p")

                            except Exception as es:
                                logger.error("task-2,error02")
                                logger.error(es)

                        except Exception as es :
                            logger.error("task为-2时error")
                            logger.error(es)
                    else:
                        pass

                    redis5.set(truck.truck_index_to_uuid_dict[i], str(json.dumps(record)))

                except Exception as es:
                    logger.error("调度结果写入异常-redis写入异常")
                    logger.error(f"调度结果:{Seq}")
                    logger.error(es)

            for i in range(dynamic_truck_num):
                print("dispatch_setting:")
                print(redis5.get(truck.truck_index_to_uuid_dict[i]))
        except Exception as es:
            logger.error("更新不及时-1")
            logger.error(es)

        return Seq

# 下面三个函数保证程序定期执行，不用管他
def process(dispatcher):

    try:
            # 更新周期参数
        logger.info("#####################################周期更新开始#####################################")

        period_para_update()
        if get_value("dynamic_dump_num") * get_value("dynamic_excavator_num") == 0:
            raise Exception("无动态派车计划可用")
            return
        if get_value("dynamic_truck_num") == 0:
            raise Exception("无动态派车可用矿卡")
            return
        # para_process(dispatcher)
        #
        # state_process(dispatcher)

        # 清空数据库缓存
        session_mysql.commit()
        session_mysql.flush()

        # 清空数据库缓存
        session_postgre.commit()
        session_postgre.flush()
        #
        # # 周期更新
        # dispatcher.para_period_update()

        # 周期更新
        dispatcher.dispatcher_period_update()

        # 参数重置
        dispatcher.sim_para_reset()

        # try:

        # 调度计算
        dispatcher.schedule_construct()

        # except Exception as es:
        #     logger.error("更新不及时")
        #     logger.error(es)

        logger.info("#####################################周期更新结束#####################################")

    except Exception as es:
        logger.error("最外层异常捕获")
        logger.error(es)

period_para_update()
scheduler = sched.scheduler(time.time, time.sleep)
dispatcher = Dispatcher()


def perform(inc, dispatcher):
    scheduler.enter(inc, 0, perform, (inc, dispatcher))
    process(dispatcher)


def main(inc, dispatcher):
    scheduler.enter(0, 0, perform, (inc, dispatcher))
    scheduler.run()


if __name__ == "__main__":
    logger.info(" ")
    logger.info("调度系统启动")

    # dispatcher = Dispatcher()

    main(10, dispatcher)
